// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.Mode
import aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeQuerySuggestionsConfigOperationDeserializer: HttpDeserializer.NonStreaming<DescribeQuerySuggestionsConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeQuerySuggestionsConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeQuerySuggestionsConfigError(context, call, payload)
        }
        val builder = DescribeQuerySuggestionsConfigResponse.Builder()

        if (payload != null) {
            deserializeDescribeQuerySuggestionsConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeQuerySuggestionsConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeQuerySuggestionsConfigOperationBody(builder: DescribeQuerySuggestionsConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeSuggestionsConfig"))
    val INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeQueriesWithoutUserInformation"))
    val LASTCLEARTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastClearTime"))
    val LASTSUGGESTIONSBUILDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastSuggestionsBuildTime"))
    val MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinimumNumberOfQueryingUsers"))
    val MINIMUMQUERYCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinimumQueryCount"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Mode"))
    val QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("QueryLogLookBackWindowInDays"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TOTALSUGGESTIONSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalSuggestionsCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR)
        field(INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR)
        field(LASTCLEARTIME_DESCRIPTOR)
        field(LASTSUGGESTIONSBUILDTIME_DESCRIPTOR)
        field(MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR)
        field(MINIMUMQUERYCOUNT_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TOTALSUGGESTIONSCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR.index -> builder.attributeSuggestionsConfig = deserializeAttributeSuggestionsDescribeConfigDocument(deserializer)
                INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR.index -> builder.includeQueriesWithoutUserInformation = deserializeBoolean()
                LASTCLEARTIME_DESCRIPTOR.index -> builder.lastClearTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTSUGGESTIONSBUILDTIME_DESCRIPTOR.index -> builder.lastSuggestionsBuildTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR.index -> builder.minimumNumberOfQueryingUsers = deserializeInt()
                MINIMUMQUERYCOUNT_DESCRIPTOR.index -> builder.minimumQueryCount = deserializeInt()
                MODE_DESCRIPTOR.index -> builder.mode = deserializeString().let { Mode.fromValue(it) }
                QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR.index -> builder.queryLogLookBackWindowInDays = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { QuerySuggestionsStatus.fromValue(it) }
                TOTALSUGGESTIONSCOUNT_DESCRIPTOR.index -> builder.totalSuggestionsCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
