// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.DescribePrincipalMappingResponse
import aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribePrincipalMappingOperationDeserializer: HttpDeserializer.NonStreaming<DescribePrincipalMappingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePrincipalMappingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePrincipalMappingError(context, call, payload)
        }
        val builder = DescribePrincipalMappingResponse.Builder()

        if (payload != null) {
            deserializeDescribePrincipalMappingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePrincipalMappingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePrincipalMappingOperationBody(builder: DescribePrincipalMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSourceId"))
    val GROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupId"))
    val GROUPORDERINGIDSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GroupOrderingIdSummaries"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCEID_DESCRIPTOR)
        field(GROUPID_DESCRIPTOR)
        field(GROUPORDERINGIDSUMMARIES_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASOURCEID_DESCRIPTOR.index -> builder.dataSourceId = deserializeString()
                GROUPID_DESCRIPTOR.index -> builder.groupId = deserializeString()
                GROUPORDERINGIDSUMMARIES_DESCRIPTOR.index -> builder.groupOrderingIdSummaries =
                    deserializer.deserializeList(GROUPORDERINGIDSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupOrderingIdSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupOrderingIdSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
