// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.DescribeFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.FeaturedDocumentMissing
import aws.sdk.kotlin.services.kendra.model.FeaturedDocumentWithMetadata
import aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeFeaturedResultsSetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeFeaturedResultsSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeFeaturedResultsSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFeaturedResultsSetError(context, call, payload)
        }
        val builder = DescribeFeaturedResultsSetResponse.Builder()

        if (payload != null) {
            deserializeDescribeFeaturedResultsSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeFeaturedResultsSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFeaturedResultsSetOperationBody(builder: DescribeFeaturedResultsSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("CreationTimestamp"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FEATUREDDOCUMENTSMISSING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeaturedDocumentsMissing"))
    val FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeaturedDocumentsWithMetadata"))
    val FEATUREDRESULTSSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeaturedResultsSetId"))
    val FEATUREDRESULTSSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeaturedResultsSetName"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LastUpdatedTimestamp"))
    val QUERYTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryTexts"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FEATUREDDOCUMENTSMISSING_DESCRIPTOR)
        field(FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR)
        field(FEATUREDRESULTSSETID_DESCRIPTOR)
        field(FEATUREDRESULTSSETNAME_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(QUERYTEXTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeLong()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FEATUREDDOCUMENTSMISSING_DESCRIPTOR.index -> builder.featuredDocumentsMissing =
                    deserializer.deserializeList(FEATUREDDOCUMENTSMISSING_DESCRIPTOR) {
                        val col0 = mutableListOf<FeaturedDocumentMissing>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeaturedDocumentMissingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR.index -> builder.featuredDocumentsWithMetadata =
                    deserializer.deserializeList(FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR) {
                        val col0 = mutableListOf<FeaturedDocumentWithMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeaturedDocumentWithMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREDRESULTSSETID_DESCRIPTOR.index -> builder.featuredResultsSetId = deserializeString()
                FEATUREDRESULTSSETNAME_DESCRIPTOR.index -> builder.featuredResultsSetName = deserializeString()
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeLong()
                QUERYTEXTS_DESCRIPTOR.index -> builder.queryTexts =
                    deserializer.deserializeList(QUERYTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FeaturedResultsSetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
