// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.DescribeExperienceResponse
import aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration
import aws.sdk.kotlin.services.kendra.model.ExperienceEndpoint
import aws.sdk.kotlin.services.kendra.model.ExperienceStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeExperienceOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExperienceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExperienceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExperienceError(context, call, payload)
        }
        val builder = DescribeExperienceResponse.Builder()

        if (payload != null) {
            deserializeDescribeExperienceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExperienceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExperienceOperationBody(builder: DescribeExperienceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Configuration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Endpoints"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeExperienceConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTS_DESCRIPTOR.index -> builder.endpoints =
                    deserializer.deserializeList(ENDPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ExperienceEndpoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeExperienceEndpointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ExperienceStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
