// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information required for Amazon Kendra Web Crawler.
 */
public class WebCrawlerConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information required to connect to websites using authentication.
     *
     * You can connect to websites using basic authentication of user name and password. You use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) to store your authentication credentials.
     *
     * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
     */
    public val authenticationConfiguration: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration? = builder.authenticationConfiguration
    /**
     * The 'depth' or number of levels from the seed level to crawl. For example, the seed URL page is depth 1 and any hyperlinks on this page that are also crawled are depth 2.
     */
    public val crawlDepth: kotlin.Int? = builder.crawlDepth
    /**
     * The maximum size (in MB) of a web page or attachment to crawl.
     *
     * Files larger than this size (in MB) are skipped/not crawled.
     *
     * The default maximum size of a web page or attachment is set to 50 MB.
     */
    public val maxContentSizePerPageInMegaBytes: kotlin.Float? = builder.maxContentSizePerPageInMegaBytes
    /**
     * The maximum number of URLs on a web page to include when crawling a website. This number is per web page.
     *
     * As a website’s web pages are crawled, any URLs the web pages link to are also crawled. URLs on a web page are crawled in order of appearance.
     *
     * The default maximum links per page is 100.
     */
    public val maxLinksPerPage: kotlin.Int? = builder.maxLinksPerPage
    /**
     * The maximum number of URLs crawled per website host per minute.
     *
     * A minimum of one URL is required.
     *
     * The default maximum number of URLs crawled per website host per minute is 300.
     */
    public val maxUrlsPerMinuteCrawlRate: kotlin.Int? = builder.maxUrlsPerMinuteCrawlRate
    /**
     * Configuration information required to connect to your internal websites via a web proxy.
     *
     * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
     *
     * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
     */
    public val urlExclusionPatterns: List<String>? = builder.urlExclusionPatterns
    /**
     * A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
     */
    public val urlInclusionPatterns: List<String>? = builder.urlInclusionPatterns
    /**
     * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
     *
     * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
     *
     * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
     *
     * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.*
     */
    public val urls: aws.sdk.kotlin.services.kendra.model.Urls? = builder.urls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebCrawlerConfiguration(")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("crawlDepth=$crawlDepth,")
        append("maxContentSizePerPageInMegaBytes=$maxContentSizePerPageInMegaBytes,")
        append("maxLinksPerPage=$maxLinksPerPage,")
        append("maxUrlsPerMinuteCrawlRate=$maxUrlsPerMinuteCrawlRate,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("urlExclusionPatterns=$urlExclusionPatterns,")
        append("urlInclusionPatterns=$urlInclusionPatterns,")
        append("urls=$urls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfiguration?.hashCode() ?: 0
        result = 31 * result + (crawlDepth ?: 0)
        result = 31 * result + (maxContentSizePerPageInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (maxLinksPerPage ?: 0)
        result = 31 * result + (maxUrlsPerMinuteCrawlRate ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (urlExclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (urlInclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (urls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebCrawlerConfiguration

        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (crawlDepth != other.crawlDepth) return false
        if (!(maxContentSizePerPageInMegaBytes?.equals(other.maxContentSizePerPageInMegaBytes) ?: (other.maxContentSizePerPageInMegaBytes == null))) return false
        if (maxLinksPerPage != other.maxLinksPerPage) return false
        if (maxUrlsPerMinuteCrawlRate != other.maxUrlsPerMinuteCrawlRate) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (urlExclusionPatterns != other.urlExclusionPatterns) return false
        if (urlInclusionPatterns != other.urlInclusionPatterns) return false
        if (urls != other.urls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration information required to connect to websites using authentication.
         *
         * You can connect to websites using basic authentication of user name and password. You use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) to store your authentication credentials.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
         */
        public var authenticationConfiguration: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration? = null
        /**
         * The 'depth' or number of levels from the seed level to crawl. For example, the seed URL page is depth 1 and any hyperlinks on this page that are also crawled are depth 2.
         */
        public var crawlDepth: kotlin.Int? = null
        /**
         * The maximum size (in MB) of a web page or attachment to crawl.
         *
         * Files larger than this size (in MB) are skipped/not crawled.
         *
         * The default maximum size of a web page or attachment is set to 50 MB.
         */
        public var maxContentSizePerPageInMegaBytes: kotlin.Float? = null
        /**
         * The maximum number of URLs on a web page to include when crawling a website. This number is per web page.
         *
         * As a website’s web pages are crawled, any URLs the web pages link to are also crawled. URLs on a web page are crawled in order of appearance.
         *
         * The default maximum links per page is 100.
         */
        public var maxLinksPerPage: kotlin.Int? = null
        /**
         * The maximum number of URLs crawled per website host per minute.
         *
         * A minimum of one URL is required.
         *
         * The default maximum number of URLs crawled per website host per minute is 300.
         */
        public var maxUrlsPerMinuteCrawlRate: kotlin.Int? = null
        /**
         * Configuration information required to connect to your internal websites via a web proxy.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
         *
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = null
        /**
         * A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        public var urlExclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        public var urlInclusionPatterns: List<String>? = null
        /**
         * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
         *
         * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
         *
         * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
         *
         * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.*
         */
        public var urls: aws.sdk.kotlin.services.kendra.model.Urls? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration) : this() {
            this.authenticationConfiguration = x.authenticationConfiguration
            this.crawlDepth = x.crawlDepth
            this.maxContentSizePerPageInMegaBytes = x.maxContentSizePerPageInMegaBytes
            this.maxLinksPerPage = x.maxLinksPerPage
            this.maxUrlsPerMinuteCrawlRate = x.maxUrlsPerMinuteCrawlRate
            this.proxyConfiguration = x.proxyConfiguration
            this.urlExclusionPatterns = x.urlExclusionPatterns
            this.urlInclusionPatterns = x.urlInclusionPatterns
            this.urls = x.urls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = WebCrawlerConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration] inside the given [block]
         */
        public fun authenticationConfiguration(block: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.authenticationConfiguration = aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ProxyConfiguration] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.Urls] inside the given [block]
         */
        public fun urls(block: aws.sdk.kotlin.services.kendra.model.Urls.Builder.() -> kotlin.Unit) {
            this.urls = aws.sdk.kotlin.services.kendra.model.Urls.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
