// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the user context for an Amazon Kendra index.
 *
 * User context filtering is a kind of personalized search with the benefit of controlling access to documents. For example, not all teams that search the company portal for information should access top-secret company documents, nor are these documents relevant to all users. Only specific users or groups of teams given access to top-secret documents should see these documents in their search results.
 *
 * You provide one of the following:
 * + User token
 * + User ID, the groups the user belongs to, and any data sources the groups can access.
 *
 * If you provide both, an exception is thrown.
 *
 * If you're using an Amazon Kendra Gen AI Enterprise Edition index, you can use `UserId`, `Groups`, and `DataSourceGroups` to filter content. If you set the `UserId` to a particular user ID, it also includes all public documents.
 *
 * Amazon Kendra Gen AI Enterprise Edition indices don't support token based document filtering. If you're using an Amazon Kendra Gen AI Enterprise Edition index, Amazon Kendra returns a `ValidationException` error if the `Token` field has a non-null value.
 */
public class UserContext private constructor(builder: Builder) {
    /**
     * The list of data source groups you want to filter search results based on groups' access to documents in that data source.
     */
    public val dataSourceGroups: List<DataSourceGroup>? = builder.dataSourceGroups
    /**
     * The list of groups you want to filter search results based on the groups' access to documents.
     */
    public val groups: List<String>? = builder.groups
    /**
     * The user context token for filtering search results for a user. It must be a JWT or a JSON token.
     */
    public val token: kotlin.String? = builder.token
    /**
     * The identifier of the user you want to filter search results based on their access to documents.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UserContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserContext(")
        append("dataSourceGroups=$dataSourceGroups,")
        append("groups=$groups,")
        append("token=$token,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceGroups?.hashCode() ?: 0
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (token?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserContext

        if (dataSourceGroups != other.dataSourceGroups) return false
        if (groups != other.groups) return false
        if (token != other.token) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UserContext = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of data source groups you want to filter search results based on groups' access to documents in that data source.
         */
        public var dataSourceGroups: List<DataSourceGroup>? = null
        /**
         * The list of groups you want to filter search results based on the groups' access to documents.
         */
        public var groups: List<String>? = null
        /**
         * The user context token for filtering search results for a user. It must be a JWT or a JSON token.
         */
        public var token: kotlin.String? = null
        /**
         * The identifier of the user you want to filter search results based on their access to documents.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UserContext) : this() {
            this.dataSourceGroups = x.dataSourceGroups
            this.groups = x.groups
            this.token = x.token
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UserContext = UserContext(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
