// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateQuerySuggestionsBlockListRequest private constructor(builder: Builder) {
    /**
     * A new description for the block list.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the block list you want to update.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The identifier of the index for the block list.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * A new name for the block list.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The IAM (Identity and Access Management) role used to access the block list text file in S3.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The S3 path where your block list text file sits in S3.
     *
     * If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the `UpdateQuerySuggestionsBlockList` API to refresh you block list.
     *
     * If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.
     */
    public val sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sourceS3Path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateQuerySuggestionsBlockListRequest(")
        append("description=$description,")
        append("id=$id,")
        append("indexId=$indexId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sourceS3Path=$sourceS3Path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateQuerySuggestionsBlockListRequest

        if (description != other.description) return false
        if (id != other.id) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sourceS3Path != other.sourceS3Path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A new description for the block list.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the block list you want to update.
         */
        public var id: kotlin.String? = null
        /**
         * The identifier of the index for the block list.
         */
        public var indexId: kotlin.String? = null
        /**
         * A new name for the block list.
         */
        public var name: kotlin.String? = null
        /**
         * The IAM (Identity and Access Management) role used to access the block list text file in S3.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The S3 path where your block list text file sits in S3.
         *
         * If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the `UpdateQuerySuggestionsBlockList` API to refresh you block list.
         *
         * If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.
         */
        public var sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListRequest) : this() {
            this.description = x.description
            this.id = x.id
            this.indexId = x.indexId
            this.name = x.name
            this.roleArn = x.roleArn
            this.sourceS3Path = x.sourceS3Path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListRequest = UpdateQuerySuggestionsBlockListRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun sourceS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sourceS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
