// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the document attribute to use to sort the response to a Amazon Kendra query. You can specify a single attribute for sorting. The attribute must have the `Sortable` flag set to `true`, otherwise Amazon Kendra returns an exception.
 *
 * You can sort attributes of the following types.
 * + Date value
 * + Long value
 * + String value
 *
 * You can't sort attributes of the following type.
 * + String list value
 */
public class SortingConfiguration private constructor(builder: Builder) {
    /**
     * The name of the document attribute used to sort the response. You can use any field that has the `Sortable` flag set to true.
     *
     * You can also sort by any of the following built-in attributes:
     * + _category
     * + _created_at
     * + _last_updated_at
     * + _version
     * + _view_count
     */
    public val documentAttributeKey: kotlin.String = requireNotNull(builder.documentAttributeKey) { "A non-null value must be provided for documentAttributeKey" }
    /**
     * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.
     */
    public val sortOrder: aws.sdk.kotlin.services.kendra.model.SortOrder = requireNotNull(builder.sortOrder) { "A non-null value must be provided for sortOrder" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SortingConfiguration(")
        append("documentAttributeKey=$documentAttributeKey,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentAttributeKey.hashCode()
        result = 31 * result + (sortOrder.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SortingConfiguration

        if (documentAttributeKey != other.documentAttributeKey) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the document attribute used to sort the response. You can use any field that has the `Sortable` flag set to true.
         *
         * You can also sort by any of the following built-in attributes:
         * + _category
         * + _created_at
         * + _last_updated_at
         * + _version
         * + _view_count
         */
        public var documentAttributeKey: kotlin.String? = null
        /**
         * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.
         */
        public var sortOrder: aws.sdk.kotlin.services.kendra.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SortingConfiguration) : this() {
            this.documentAttributeKey = x.documentAttributeKey
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = SortingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (documentAttributeKey == null) documentAttributeKey = ""
            if (sortOrder == null) sortOrder = SortOrder.SdkUnknown("no value provided")
            return this
        }
    }
}
