// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information for the sitemap URLs to crawl.
 *
 * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.*
 */
public class SiteMapsConfiguration private constructor(builder: Builder) {
    /**
     * The list of sitemap URLs of the websites you want to crawl.
     *
     * The list can include a maximum of three sitemap URLs.
     */
    public val siteMaps: List<String> = requireNotNull(builder.siteMaps) { "A non-null value must be provided for siteMaps" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SiteMapsConfiguration(")
        append("siteMaps=$siteMaps")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = siteMaps.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SiteMapsConfiguration

        if (siteMaps != other.siteMaps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of sitemap URLs of the websites you want to crawl.
         *
         * The list can include a maximum of three sitemap URLs.
         */
        public var siteMaps: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration) : this() {
            this.siteMaps = x.siteMaps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration = SiteMapsConfiguration(this)

        internal fun correctErrors(): Builder {
            if (siteMaps == null) siteMaps = emptyList()
            return this
        }
    }
}
