// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to Microsoft SharePoint as your data source.
 */
public class SharePointConfiguration private constructor(builder: Builder) {
    /**
     * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication of client secret.
     */
    public val authenticationType: aws.sdk.kotlin.services.kendra.model.SharePointOnlineAuthenticationType? = builder.authenticationType
    /**
     * `TRUE` to index document attachments.
     */
    public val crawlAttachments: kotlin.Boolean = builder.crawlAttachments
    /**
     * `TRUE` to disable local groups information.
     */
    public val disableLocalGroups: kotlin.Boolean = builder.disableLocalGroups
    /**
     * The Microsoft SharePoint attribute field that contains the title of the document.
     */
    public val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
     *
     * The regex applies to the display URL of the SharePoint document.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map SharePoint data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to SharePoint fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The SharePoint data source field names must exist in your SharePoint custom metadata.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain documents in your SharePoint. Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
     *
     * The regex applies to the display URL of the SharePoint document.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You can use this option for SharePoint Server.
     *
     * You must provide the website host name and port number. For example, the host name of *https://a.example.com/page1.html* is "a.example.com" and the port is 443, the standard port for HTTPS.
     *
     * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.
     *
     * It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the SharePoint instance. For more information, see [Microsoft SharePoint](https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The version of Microsoft SharePoint that you use.
     */
    public val sharePointVersion: aws.sdk.kotlin.services.kendra.model.SharePointVersion = requireNotNull(builder.sharePointVersion) { "A non-null value must be provided for sharePointVersion" }
    /**
     * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server if you require a secure SSL connection.
     *
     * You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html).
     */
    public val sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sslCertificateS3Path
    /**
     * The Microsoft SharePoint site URLs for the documents you want to index.
     */
    public val urls: List<String> = requireNotNull(builder.urls) { "A non-null value must be provided for urls" }
    /**
     * `TRUE` to use the SharePoint change log to determine which documents require updating in the index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.
     */
    public val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SharePointConfiguration(")
        append("authenticationType=$authenticationType,")
        append("crawlAttachments=$crawlAttachments,")
        append("disableLocalGroups=$disableLocalGroups,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("secretArn=$secretArn,")
        append("sharePointVersion=$sharePointVersion,")
        append("sslCertificateS3Path=$sslCertificateS3Path,")
        append("urls=$urls,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (crawlAttachments.hashCode())
        result = 31 * result + (disableLocalGroups.hashCode())
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (sharePointVersion.hashCode())
        result = 31 * result + (sslCertificateS3Path?.hashCode() ?: 0)
        result = 31 * result + (urls.hashCode())
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SharePointConfiguration

        if (authenticationType != other.authenticationType) return false
        if (crawlAttachments != other.crawlAttachments) return false
        if (disableLocalGroups != other.disableLocalGroups) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (sharePointVersion != other.sharePointVersion) return false
        if (sslCertificateS3Path != other.sslCertificateS3Path) return false
        if (urls != other.urls) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication of client secret.
         */
        public var authenticationType: aws.sdk.kotlin.services.kendra.model.SharePointOnlineAuthenticationType? = null
        /**
         * `TRUE` to index document attachments.
         */
        public var crawlAttachments: kotlin.Boolean = false
        /**
         * `TRUE` to disable local groups information.
         */
        public var disableLocalGroups: kotlin.Boolean = false
        /**
         * The Microsoft SharePoint attribute field that contains the title of the document.
         */
        public var documentTitleFieldName: kotlin.String? = null
        /**
         * A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         *
         * The regex applies to the display URL of the SharePoint document.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map SharePoint data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to SharePoint fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The SharePoint data source field names must exist in your SharePoint custom metadata.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain documents in your SharePoint. Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         *
         * The regex applies to the display URL of the SharePoint document.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You can use this option for SharePoint Server.
         *
         * You must provide the website host name and port number. For example, the host name of *https://a.example.com/page1.html* is "a.example.com" and the port is 443, the standard port for HTTPS.
         *
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.
         *
         * It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the SharePoint instance. For more information, see [Microsoft SharePoint](https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * The version of Microsoft SharePoint that you use.
         */
        public var sharePointVersion: aws.sdk.kotlin.services.kendra.model.SharePointVersion? = null
        /**
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server if you require a secure SSL connection.
         *
         * You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html).
         */
        public var sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * The Microsoft SharePoint site URLs for the documents you want to index.
         */
        public var urls: List<String>? = null
        /**
         * `TRUE` to use the SharePoint change log to determine which documents require updating in the index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.
         */
        public var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SharePointConfiguration) : this() {
            this.authenticationType = x.authenticationType
            this.crawlAttachments = x.crawlAttachments
            this.disableLocalGroups = x.disableLocalGroups
            this.documentTitleFieldName = x.documentTitleFieldName
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.proxyConfiguration = x.proxyConfiguration
            this.secretArn = x.secretArn
            this.sharePointVersion = x.sharePointVersion
            this.sslCertificateS3Path = x.sslCertificateS3Path
            this.urls = x.urls
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = SharePointConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ProxyConfiguration] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun sslCertificateS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sslCertificateS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (secretArn == null) secretArn = ""
            if (sharePointVersion == null) sharePointVersion = SharePointVersion.SdkUnknown("no value provided")
            if (urls == null) urls = emptyList()
            return this
        }
    }
}
