// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information for the seed or starting point URLs to crawl.
 *
 * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.*
 */
public class SeedUrlConfiguration private constructor(builder: Builder) {
    /**
     * The list of seed or starting point URLs of the websites you want to crawl.
     *
     * The list can include a maximum of 100 seed URLs.
     */
    public val seedUrls: List<String> = requireNotNull(builder.seedUrls) { "A non-null value must be provided for seedUrls" }
    /**
     * You can choose one of the following modes:
     * + `HOST_ONLY`—crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
     * + `SUBDOMAINS`—crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
     * + `EVERYTHING`—crawl the website host names with subdomains and other domains that the web pages link to.
     *
     * The default mode is set to `HOST_ONLY`.
     */
    public val webCrawlerMode: aws.sdk.kotlin.services.kendra.model.WebCrawlerMode? = builder.webCrawlerMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SeedUrlConfiguration(")
        append("seedUrls=$seedUrls,")
        append("webCrawlerMode=$webCrawlerMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = seedUrls.hashCode()
        result = 31 * result + (webCrawlerMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SeedUrlConfiguration

        if (seedUrls != other.seedUrls) return false
        if (webCrawlerMode != other.webCrawlerMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of seed or starting point URLs of the websites you want to crawl.
         *
         * The list can include a maximum of 100 seed URLs.
         */
        public var seedUrls: List<String>? = null
        /**
         * You can choose one of the following modes:
         * + `HOST_ONLY`—crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         * + `SUBDOMAINS`—crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         * + `EVERYTHING`—crawl the website host names with subdomains and other domains that the web pages link to.
         *
         * The default mode is set to `HOST_ONLY`.
         */
        public var webCrawlerMode: aws.sdk.kotlin.services.kendra.model.WebCrawlerMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration) : this() {
            this.seedUrls = x.seedUrls
            this.webCrawlerMode = x.webCrawlerMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration = SeedUrlConfiguration(this)

        internal fun correctErrors(): Builder {
            if (seedUrls == null) seedUrls = emptyList()
            return this
        }
    }
}
