// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information for indexing a single standard object.
 */
public class SalesforceStandardObjectConfiguration private constructor(builder: Builder) {
    /**
     * The name of the field in the standard object table that contains the document contents.
     */
    public val documentDataFieldName: kotlin.String = requireNotNull(builder.documentDataFieldName) { "A non-null value must be provided for documentDataFieldName" }
    /**
     * The name of the field in the standard object table that contains the document title.
     */
    public val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * Maps attributes or field names of the standard object to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * The name of the standard object.
     */
    public val name: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectName = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceStandardObjectConfiguration(")
        append("documentDataFieldName=$documentDataFieldName,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("fieldMappings=$fieldMappings,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentDataFieldName.hashCode()
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceStandardObjectConfiguration

        if (documentDataFieldName != other.documentDataFieldName) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (fieldMappings != other.fieldMappings) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the field in the standard object table that contains the document contents.
         */
        public var documentDataFieldName: kotlin.String? = null
        /**
         * The name of the field in the standard object table that contains the document title.
         */
        public var documentTitleFieldName: kotlin.String? = null
        /**
         * Maps attributes or field names of the standard object to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The name of the standard object.
         */
        public var name: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration) : this() {
            this.documentDataFieldName = x.documentDataFieldName
            this.documentTitleFieldName = x.documentTitleFieldName
            this.fieldMappings = x.fieldMappings
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = SalesforceStandardObjectConfiguration(this)

        internal fun correctErrors(): Builder {
            if (documentDataFieldName == null) documentDataFieldName = ""
            if (name == null) name = SalesforceStandardObjectName.SdkUnknown("no value provided")
            return this
        }
    }
}
