// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information required to find a specific file in an Amazon S3 bucket.
 */
public class S3Path private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket that contains the file.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The name of the file.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.S3Path = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Path(")
        append("bucket=$bucket,")
        append("key=$key")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (key.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Path

        if (bucket != other.bucket) return false
        if (key != other.key) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.S3Path = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the S3 bucket that contains the file.
         */
        public var bucket: kotlin.String? = null
        /**
         * The name of the file.
         */
        public var key: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.S3Path) : this() {
            this.bucket = x.bucket
            this.key = x.key
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.S3Path = S3Path(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (key == null) key = ""
            return this
        }
    }
}
