// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to an Amazon S3 bucket.
 *
 * Amazon Kendra now supports an upgraded Amazon S3 connector.
 *
 * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `S3DataSourceConfiguration` object to configure your connector.
 *
 * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
 *
 * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
 */
public class S3DataSourceConfiguration private constructor(builder: Builder) {
    /**
     * Provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
     */
    public val accessControlListConfiguration: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration? = builder.accessControlListConfiguration
    /**
     * The name of the bucket that contains the documents.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document.
     */
    public val documentsMetadataConfiguration: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration? = builder.documentsMetadataConfiguration
    /**
     * A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to exclude from your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:
     * + *&#47;myapp/config&#47;**—All files inside config directory.
     * + ***&#47;*.png*—All .png files in all directories.
     * + ***&#47;*.{png, ico, md}*—All .png, .ico or .md files in all directories.
     * + *&#47;myapp/src&#47;**&#47;*.ts*—All .ts files inside src directory (and all its subdirectories).
     * + ***&#47;!(*.module).ts*—All .ts files but not .module.ts
     * + **.png , *.jpg*—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).
     * + **internal**—All files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.
     * + ***&#47;*internal**—All internal-related files in a directory and its subdirectories.
     *
     * For more examples, see [Use of Exclude and Include Filters](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) in the Amazon Web Services CLI Command Reference.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to include in your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:
     * + *&#47;myapp/config&#47;**—All files inside config directory.
     * + ***&#47;*.png*—All .png files in all directories.
     * + ***&#47;*.{png, ico, md}*—All .png, .ico or .md files in all directories.
     * + *&#47;myapp/src&#47;**&#47;*.ts*—All .ts files inside src directory (and all its subdirectories).
     * + ***&#47;!(*.module).ts*—All .ts files but not .module.ts
     * + **.png , *.jpg*—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).
     * + **internal**—All files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.
     * + ***&#47;*internal**—All internal-related files in a directory and its subdirectories.
     *
     * For more examples, see [Use of Exclude and Include Filters](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) in the Amazon Web Services CLI Command Reference.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of S3 prefixes for the documents that should be included in the index.
     */
    public val inclusionPrefixes: List<String>? = builder.inclusionPrefixes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataSourceConfiguration(")
        append("accessControlListConfiguration=$accessControlListConfiguration,")
        append("bucketName=$bucketName,")
        append("documentsMetadataConfiguration=$documentsMetadataConfiguration,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("inclusionPrefixes=$inclusionPrefixes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlListConfiguration?.hashCode() ?: 0
        result = 31 * result + (bucketName.hashCode())
        result = 31 * result + (documentsMetadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPrefixes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataSourceConfiguration

        if (accessControlListConfiguration != other.accessControlListConfiguration) return false
        if (bucketName != other.bucketName) return false
        if (documentsMetadataConfiguration != other.documentsMetadataConfiguration) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (inclusionPrefixes != other.inclusionPrefixes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
         */
        public var accessControlListConfiguration: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration? = null
        /**
         * The name of the bucket that contains the documents.
         */
        public var bucketName: kotlin.String? = null
        /**
         * Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document.
         */
        public var documentsMetadataConfiguration: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration? = null
        /**
         * A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to exclude from your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:
         * + *&#47;myapp/config&#47;**—All files inside config directory.
         * + ***&#47;*.png*—All .png files in all directories.
         * + ***&#47;*.{png, ico, md}*—All .png, .ico or .md files in all directories.
         * + *&#47;myapp/src&#47;**&#47;*.ts*—All .ts files inside src directory (and all its subdirectories).
         * + ***&#47;!(*.module).ts*—All .ts files but not .module.ts
         * + **.png , *.jpg*—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).
         * + **internal**—All files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.
         * + ***&#47;*internal**—All internal-related files in a directory and its subdirectories.
         *
         * For more examples, see [Use of Exclude and Include Filters](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) in the Amazon Web Services CLI Command Reference.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to include in your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:
         * + *&#47;myapp/config&#47;**—All files inside config directory.
         * + ***&#47;*.png*—All .png files in all directories.
         * + ***&#47;*.{png, ico, md}*—All .png, .ico or .md files in all directories.
         * + *&#47;myapp/src&#47;**&#47;*.ts*—All .ts files inside src directory (and all its subdirectories).
         * + ***&#47;!(*.module).ts*—All .ts files but not .module.ts
         * + **.png , *.jpg*—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).
         * + **internal**—All files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.
         * + ***&#47;*internal**—All internal-related files in a directory and its subdirectories.
         *
         * For more examples, see [Use of Exclude and Include Filters](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) in the Amazon Web Services CLI Command Reference.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * A list of S3 prefixes for the documents that should be included in the index.
         */
        public var inclusionPrefixes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration) : this() {
            this.accessControlListConfiguration = x.accessControlListConfiguration
            this.bucketName = x.bucketName
            this.documentsMetadataConfiguration = x.documentsMetadataConfiguration
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.inclusionPrefixes = x.inclusionPrefixes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = S3DataSourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration] inside the given [block]
         */
        public fun accessControlListConfiguration(block: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration.Builder.() -> kotlin.Unit) {
            this.accessControlListConfiguration = aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration] inside the given [block]
         */
        public fun documentsMetadataConfiguration(block: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.documentsMetadataConfiguration = aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
