// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single retrieved relevant passage result.
 */
public class RetrieveResultItem private constructor(builder: Builder) {
    /**
     * The contents of the relevant passage.
     */
    public val content: kotlin.String? = builder.content
    /**
     * An array of document fields/attributes assigned to a document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
     */
    public val documentAttributes: List<DocumentAttribute>? = builder.documentAttributes
    /**
     * The identifier of the document.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * The title of the document.
     */
    public val documentTitle: kotlin.String? = builder.documentTitle
    /**
     * The URI of the original location of the document.
     */
    public val documentUri: kotlin.String? = builder.documentUri
    /**
     * The identifier of the relevant passage result.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.
     */
    public val scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = builder.scoreAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.RetrieveResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetrieveResultItem(")
        append("content=$content,")
        append("documentAttributes=$documentAttributes,")
        append("documentId=$documentId,")
        append("documentTitle=$documentTitle,")
        append("documentUri=$documentUri,")
        append("id=$id,")
        append("scoreAttributes=$scoreAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (documentAttributes?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (documentTitle?.hashCode() ?: 0)
        result = 31 * result + (documentUri?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (scoreAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetrieveResultItem

        if (content != other.content) return false
        if (documentAttributes != other.documentAttributes) return false
        if (documentId != other.documentId) return false
        if (documentTitle != other.documentTitle) return false
        if (documentUri != other.documentUri) return false
        if (id != other.id) return false
        if (scoreAttributes != other.scoreAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.RetrieveResultItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The contents of the relevant passage.
         */
        public var content: kotlin.String? = null
        /**
         * An array of document fields/attributes assigned to a document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
         */
        public var documentAttributes: List<DocumentAttribute>? = null
        /**
         * The identifier of the document.
         */
        public var documentId: kotlin.String? = null
        /**
         * The title of the document.
         */
        public var documentTitle: kotlin.String? = null
        /**
         * The URI of the original location of the document.
         */
        public var documentUri: kotlin.String? = null
        /**
         * The identifier of the relevant passage result.
         */
        public var id: kotlin.String? = null
        /**
         * The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.
         */
        public var scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.RetrieveResultItem) : this() {
            this.content = x.content
            this.documentAttributes = x.documentAttributes
            this.documentId = x.documentId
            this.documentTitle = x.documentTitle
            this.documentUri = x.documentUri
            this.id = x.id
            this.scoreAttributes = x.scoreAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.RetrieveResultItem = RetrieveResultItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ScoreAttributes] inside the given [block]
         */
        public fun scoreAttributes(block: aws.sdk.kotlin.services.kendra.model.ScoreAttributes.Builder.() -> kotlin.Unit) {
            this.scoreAttributes = aws.sdk.kotlin.services.kendra.model.ScoreAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
