// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RetrieveRequest private constructor(builder: Builder) {
    /**
     * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
     *
     * The `AttributeFilter` parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.
     *
     * For Amazon Kendra Gen AI Enterprise Edition indices use `AttributeFilter` to enable document filtering for end users using `_email_id` or include public documents (`_email_id=null`).
     */
    public val attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = builder.attributeFilter
    /**
     * Overrides relevance tuning configurations of fields/attributes set at the index level.
     *
     * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
     *
     * If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
     */
    public val documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = builder.documentRelevanceOverrideConfigurations
    /**
     * The identifier of the index to retrieve relevant passages for the search.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * Retrieved relevant passages are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
     */
    public val pageNumber: kotlin.Int? = builder.pageNumber
    /**
     * Sets the number of retrieved relevant passages that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     */
    public val pageSize: kotlin.Int? = builder.pageSize
    /**
     * The input query text to retrieve relevant passages for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, `Timeoff AND October AND Category:HR` is counted as 3 tokens: `timeoff`, `october`, `hr`. For more information, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax) in the Amazon Kendra Developer Guide.
     */
    public val queryText: kotlin.String? = builder.queryText
    /**
     * A list of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document fields are included in the response.
     */
    public val requestedDocumentAttributes: List<String>? = builder.requestedDocumentAttributes
    /**
     * The user context token or user and group information.
     */
    public val userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = builder.userContext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.RetrieveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetrieveRequest(")
        append("attributeFilter=$attributeFilter,")
        append("documentRelevanceOverrideConfigurations=$documentRelevanceOverrideConfigurations,")
        append("indexId=$indexId,")
        append("pageNumber=$pageNumber,")
        append("pageSize=$pageSize,")
        append("queryText=$queryText,")
        append("requestedDocumentAttributes=$requestedDocumentAttributes,")
        append("userContext=$userContext")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeFilter?.hashCode() ?: 0
        result = 31 * result + (documentRelevanceOverrideConfigurations?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (pageNumber ?: 0)
        result = 31 * result + (pageSize ?: 0)
        result = 31 * result + (queryText?.hashCode() ?: 0)
        result = 31 * result + (requestedDocumentAttributes?.hashCode() ?: 0)
        result = 31 * result + (userContext?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetrieveRequest

        if (attributeFilter != other.attributeFilter) return false
        if (documentRelevanceOverrideConfigurations != other.documentRelevanceOverrideConfigurations) return false
        if (indexId != other.indexId) return false
        if (pageNumber != other.pageNumber) return false
        if (pageSize != other.pageSize) return false
        if (queryText != other.queryText) return false
        if (requestedDocumentAttributes != other.requestedDocumentAttributes) return false
        if (userContext != other.userContext) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.RetrieveRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
         *
         * The `AttributeFilter` parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.
         *
         * For Amazon Kendra Gen AI Enterprise Edition indices use `AttributeFilter` to enable document filtering for end users using `_email_id` or include public documents (`_email_id=null`).
         */
        public var attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = null
        /**
         * Overrides relevance tuning configurations of fields/attributes set at the index level.
         *
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         *
         * If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
         */
        public var documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = null
        /**
         * The identifier of the index to retrieve relevant passages for the search.
         */
        public var indexId: kotlin.String? = null
        /**
         * Retrieved relevant passages are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
         */
        public var pageNumber: kotlin.Int? = null
        /**
         * Sets the number of retrieved relevant passages that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
         */
        public var pageSize: kotlin.Int? = null
        /**
         * The input query text to retrieve relevant passages for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, `Timeoff AND October AND Category:HR` is counted as 3 tokens: `timeoff`, `october`, `hr`. For more information, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax) in the Amazon Kendra Developer Guide.
         */
        public var queryText: kotlin.String? = null
        /**
         * A list of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document fields are included in the response.
         */
        public var requestedDocumentAttributes: List<String>? = null
        /**
         * The user context token or user and group information.
         */
        public var userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.RetrieveRequest) : this() {
            this.attributeFilter = x.attributeFilter
            this.documentRelevanceOverrideConfigurations = x.documentRelevanceOverrideConfigurations
            this.indexId = x.indexId
            this.pageNumber = x.pageNumber
            this.pageSize = x.pageSize
            this.queryText = x.queryText
            this.requestedDocumentAttributes = x.requestedDocumentAttributes
            this.userContext = x.userContext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.RetrieveRequest = RetrieveRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.kendra.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.kendra.model.AttributeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserContext] inside the given [block]
         */
        public fun userContext(block: aws.sdk.kotlin.services.kendra.model.UserContext.Builder.() -> kotlin.Unit) {
            this.userContext = aws.sdk.kotlin.services.kendra.model.UserContext.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
