// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information for tuning the relevance of a field in a search. When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.
 */
public class Relevance private constructor(builder: Builder) {
    /**
     * Specifies the time period that the boost applies to. For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week.
     *
     * Only applies to `DATE` fields.
     */
    public val duration: kotlin.String? = builder.duration
    /**
     * Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to `DATE` fields.
     */
    public val freshness: kotlin.Boolean? = builder.freshness
    /**
     * The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers.
     */
    public val importance: kotlin.Int? = builder.importance
    /**
     * Determines how values should be interpreted.
     *
     * When the `RankOrder` field is `ASCENDING`, higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
     *
     * When the `RankOrder` field is `DESCENDING`, lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
     *
     * Only applies to `LONG` fields.
     */
    public val rankOrder: aws.sdk.kotlin.services.kendra.model.Order? = builder.rankOrder
    /**
     * A list of values that should be given a different boost when they appear in the result list. For example, if you are boosting a field called "department", query terms that match the department field are boosted in the result. However, you can add entries from the department field to boost documents with those values higher.
     *
     * For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document. When those terms appear they are given the specified importance instead of the regular importance for the boost.
     */
    public val valueImportanceMap: Map<String, Int>? = builder.valueImportanceMap

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Relevance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Relevance(")
        append("duration=$duration,")
        append("freshness=$freshness,")
        append("importance=$importance,")
        append("rankOrder=$rankOrder,")
        append("valueImportanceMap=$valueImportanceMap")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration?.hashCode() ?: 0
        result = 31 * result + (freshness?.hashCode() ?: 0)
        result = 31 * result + (importance ?: 0)
        result = 31 * result + (rankOrder?.hashCode() ?: 0)
        result = 31 * result + (valueImportanceMap?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Relevance

        if (duration != other.duration) return false
        if (freshness != other.freshness) return false
        if (importance != other.importance) return false
        if (rankOrder != other.rankOrder) return false
        if (valueImportanceMap != other.valueImportanceMap) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Relevance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the time period that the boost applies to. For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week.
         *
         * Only applies to `DATE` fields.
         */
        public var duration: kotlin.String? = null
        /**
         * Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to `DATE` fields.
         */
        public var freshness: kotlin.Boolean? = null
        /**
         * The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers.
         */
        public var importance: kotlin.Int? = null
        /**
         * Determines how values should be interpreted.
         *
         * When the `RankOrder` field is `ASCENDING`, higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
         *
         * When the `RankOrder` field is `DESCENDING`, lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
         *
         * Only applies to `LONG` fields.
         */
        public var rankOrder: aws.sdk.kotlin.services.kendra.model.Order? = null
        /**
         * A list of values that should be given a different boost when they appear in the result list. For example, if you are boosting a field called "department", query terms that match the department field are boosted in the result. However, you can add entries from the department field to boost documents with those values higher.
         *
         * For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document. When those terms appear they are given the specified importance instead of the regular importance for the boost.
         */
        public var valueImportanceMap: Map<String, Int>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Relevance) : this() {
            this.duration = x.duration
            this.freshness = x.freshness
            this.importance = x.importance
            this.rankOrder = x.rankOrder
            this.valueImportanceMap = x.valueImportanceMap
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Relevance = Relevance(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
