// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information on a query suggestions block list.
 *
 * This includes information on the block list ID, block list name, when the block list was created, when the block list was last updated, and the count of block words/phrases in the block list.
 *
 * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
 */
public class QuerySuggestionsBlockListSummary private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the block list was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The identifier of a block list.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The number of items in the block list file.
     */
    public val itemCount: kotlin.Int? = builder.itemCount
    /**
     * The name of the block list.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the block list.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = builder.status
    /**
     * The Unix timestamp when the block list was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuerySuggestionsBlockListSummary(")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("itemCount=$itemCount,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuerySuggestionsBlockListSummary

        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (itemCount != other.itemCount) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp when the block list was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a block list.
         */
        public var id: kotlin.String? = null
        /**
         * The number of items in the block list file.
         */
        public var itemCount: kotlin.Int? = null
        /**
         * The name of the block list.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the block list.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = null
        /**
         * The Unix timestamp when the block list was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary) : this() {
            this.createdAt = x.createdAt
            this.id = x.id
            this.itemCount = x.itemCount
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = QuerySuggestionsBlockListSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
