// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class QueryRequest private constructor(builder: Builder) {
    /**
     * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
     *
     * The `AttributeFilter` parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.
     *
     * For Amazon Kendra Gen AI Enterprise Edition indices use `AttributeFilter` to enable document filtering for end users using `_email_id` or include public documents (`_email_id=null`).
     */
    public val attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = builder.attributeFilter
    /**
     * Provides configuration to determine how to group results by document attribute value, and how to display them (collapsed or expanded) under a designated primary document for each group.
     */
    public val collapseConfiguration: aws.sdk.kotlin.services.kendra.model.CollapseConfiguration? = builder.collapseConfiguration
    /**
     * Overrides relevance tuning configurations of fields/attributes set at the index level.
     *
     * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
     *
     * If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
     */
    public val documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = builder.documentRelevanceOverrideConfigurations
    /**
     * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key specified. This helps your users narrow their search.
     */
    public val facets: List<Facet>? = builder.facets
    /**
     * The identifier of the index for the search.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * Query results are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
     */
    public val pageNumber: kotlin.Int? = builder.pageNumber
    /**
     * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     */
    public val pageSize: kotlin.Int? = builder.pageSize
    /**
     * Sets the type of query result or response. Only results for the specified type are returned.
     */
    public val queryResultTypeFilter: aws.sdk.kotlin.services.kendra.model.QueryResultType? = builder.queryResultTypeFilter
    /**
     * The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, `Timeoff AND October AND Category:HR` is counted as 3 tokens: `timeoff`, `october`, `hr`. For more information, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax) in the Amazon Kendra Developer Guide.
     */
    public val queryText: kotlin.String? = builder.queryText
    /**
     * An array of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document attributes are included in the response.
     */
    public val requestedDocumentAttributes: List<String>? = builder.requestedDocumentAttributes
    /**
     * Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.
     *
     * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.
     */
    public val sortingConfiguration: aws.sdk.kotlin.services.kendra.model.SortingConfiguration? = builder.sortingConfiguration
    /**
     * Provides configuration information to determine how the results of a query are sorted.
     *
     * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. The sort field quota can be increased.
     *
     * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
     */
    public val sortingConfigurations: List<SortingConfiguration>? = builder.sortingConfigurations
    /**
     * Enables suggested spell corrections for queries.
     */
    public val spellCorrectionConfiguration: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration? = builder.spellCorrectionConfiguration
    /**
     * The user context token or user and group information.
     */
    public val userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = builder.userContext
    /**
     * Provides an identifier for a specific user. The `VisitorId` should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the `VisitorId`.
     */
    public val visitorId: kotlin.String? = builder.visitorId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryRequest(")
        append("attributeFilter=$attributeFilter,")
        append("collapseConfiguration=$collapseConfiguration,")
        append("documentRelevanceOverrideConfigurations=$documentRelevanceOverrideConfigurations,")
        append("facets=$facets,")
        append("indexId=$indexId,")
        append("pageNumber=$pageNumber,")
        append("pageSize=$pageSize,")
        append("queryResultTypeFilter=$queryResultTypeFilter,")
        append("queryText=$queryText,")
        append("requestedDocumentAttributes=$requestedDocumentAttributes,")
        append("sortingConfiguration=$sortingConfiguration,")
        append("sortingConfigurations=$sortingConfigurations,")
        append("spellCorrectionConfiguration=$spellCorrectionConfiguration,")
        append("userContext=$userContext,")
        append("visitorId=$visitorId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeFilter?.hashCode() ?: 0
        result = 31 * result + (collapseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (documentRelevanceOverrideConfigurations?.hashCode() ?: 0)
        result = 31 * result + (facets?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (pageNumber ?: 0)
        result = 31 * result + (pageSize ?: 0)
        result = 31 * result + (queryResultTypeFilter?.hashCode() ?: 0)
        result = 31 * result + (queryText?.hashCode() ?: 0)
        result = 31 * result + (requestedDocumentAttributes?.hashCode() ?: 0)
        result = 31 * result + (sortingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sortingConfigurations?.hashCode() ?: 0)
        result = 31 * result + (spellCorrectionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userContext?.hashCode() ?: 0)
        result = 31 * result + (visitorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryRequest

        if (attributeFilter != other.attributeFilter) return false
        if (collapseConfiguration != other.collapseConfiguration) return false
        if (documentRelevanceOverrideConfigurations != other.documentRelevanceOverrideConfigurations) return false
        if (facets != other.facets) return false
        if (indexId != other.indexId) return false
        if (pageNumber != other.pageNumber) return false
        if (pageSize != other.pageSize) return false
        if (queryResultTypeFilter != other.queryResultTypeFilter) return false
        if (queryText != other.queryText) return false
        if (requestedDocumentAttributes != other.requestedDocumentAttributes) return false
        if (sortingConfiguration != other.sortingConfiguration) return false
        if (sortingConfigurations != other.sortingConfigurations) return false
        if (spellCorrectionConfiguration != other.spellCorrectionConfiguration) return false
        if (userContext != other.userContext) return false
        if (visitorId != other.visitorId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
         *
         * The `AttributeFilter` parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.
         *
         * For Amazon Kendra Gen AI Enterprise Edition indices use `AttributeFilter` to enable document filtering for end users using `_email_id` or include public documents (`_email_id=null`).
         */
        public var attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = null
        /**
         * Provides configuration to determine how to group results by document attribute value, and how to display them (collapsed or expanded) under a designated primary document for each group.
         */
        public var collapseConfiguration: aws.sdk.kotlin.services.kendra.model.CollapseConfiguration? = null
        /**
         * Overrides relevance tuning configurations of fields/attributes set at the index level.
         *
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         *
         * If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
         */
        public var documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = null
        /**
         * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key specified. This helps your users narrow their search.
         */
        public var facets: List<Facet>? = null
        /**
         * The identifier of the index for the search.
         */
        public var indexId: kotlin.String? = null
        /**
         * Query results are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
         */
        public var pageNumber: kotlin.Int? = null
        /**
         * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
         */
        public var pageSize: kotlin.Int? = null
        /**
         * Sets the type of query result or response. Only results for the specified type are returned.
         */
        public var queryResultTypeFilter: aws.sdk.kotlin.services.kendra.model.QueryResultType? = null
        /**
         * The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, `Timeoff AND October AND Category:HR` is counted as 3 tokens: `timeoff`, `october`, `hr`. For more information, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax) in the Amazon Kendra Developer Guide.
         */
        public var queryText: kotlin.String? = null
        /**
         * An array of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document attributes are included in the response.
         */
        public var requestedDocumentAttributes: List<String>? = null
        /**
         * Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         *
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.
         */
        public var sortingConfiguration: aws.sdk.kotlin.services.kendra.model.SortingConfiguration? = null
        /**
         * Provides configuration information to determine how the results of a query are sorted.
         *
         * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. The sort field quota can be increased.
         *
         * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
         */
        public var sortingConfigurations: List<SortingConfiguration>? = null
        /**
         * Enables suggested spell corrections for queries.
         */
        public var spellCorrectionConfiguration: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration? = null
        /**
         * The user context token or user and group information.
         */
        public var userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = null
        /**
         * Provides an identifier for a specific user. The `VisitorId` should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the `VisitorId`.
         */
        public var visitorId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryRequest) : this() {
            this.attributeFilter = x.attributeFilter
            this.collapseConfiguration = x.collapseConfiguration
            this.documentRelevanceOverrideConfigurations = x.documentRelevanceOverrideConfigurations
            this.facets = x.facets
            this.indexId = x.indexId
            this.pageNumber = x.pageNumber
            this.pageSize = x.pageSize
            this.queryResultTypeFilter = x.queryResultTypeFilter
            this.queryText = x.queryText
            this.requestedDocumentAttributes = x.requestedDocumentAttributes
            this.sortingConfiguration = x.sortingConfiguration
            this.sortingConfigurations = x.sortingConfigurations
            this.spellCorrectionConfiguration = x.spellCorrectionConfiguration
            this.userContext = x.userContext
            this.visitorId = x.visitorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryRequest = QueryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.kendra.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.kendra.model.AttributeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CollapseConfiguration] inside the given [block]
         */
        public fun collapseConfiguration(block: aws.sdk.kotlin.services.kendra.model.CollapseConfiguration.Builder.() -> kotlin.Unit) {
            this.collapseConfiguration = aws.sdk.kotlin.services.kendra.model.CollapseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SortingConfiguration] inside the given [block]
         */
        public fun sortingConfiguration(block: aws.sdk.kotlin.services.kendra.model.SortingConfiguration.Builder.() -> kotlin.Unit) {
            this.sortingConfiguration = aws.sdk.kotlin.services.kendra.model.SortingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration] inside the given [block]
         */
        public fun spellCorrectionConfiguration(block: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration.Builder.() -> kotlin.Unit) {
            this.spellCorrectionConfiguration = aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserContext] inside the given [block]
         */
        public fun userContext(block: aws.sdk.kotlin.services.kendra.model.UserContext.Builder.() -> kotlin.Unit) {
            this.userContext = aws.sdk.kotlin.services.kendra.model.UserContext.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
