// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides user and group information for [user context filtering](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
 */
public class Principal private constructor(builder: Builder) {
    /**
     * Whether to allow or deny document access to the principal.
     */
    public val access: aws.sdk.kotlin.services.kendra.model.ReadAccessType = requireNotNull(builder.access) { "A non-null value must be provided for access" }
    /**
     * The identifier of the data source the principal should access documents from.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The name of the user or group.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of principal.
     */
    public val type: aws.sdk.kotlin.services.kendra.model.PrincipalType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Principal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Principal(")
        append("access=$access,")
        append("dataSourceId=$dataSourceId,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = access.hashCode()
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Principal

        if (access != other.access) return false
        if (dataSourceId != other.dataSourceId) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Principal = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to allow or deny document access to the principal.
         */
        public var access: aws.sdk.kotlin.services.kendra.model.ReadAccessType? = null
        /**
         * The identifier of the data source the principal should access documents from.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The name of the user or group.
         */
        public var name: kotlin.String? = null
        /**
         * The type of principal.
         */
        public var type: aws.sdk.kotlin.services.kendra.model.PrincipalType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Principal) : this() {
            this.access = x.access
            this.dataSourceId = x.dataSourceId
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Principal = Principal(this)

        internal fun correctErrors(): Builder {
            if (access == null) access = ReadAccessType.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (type == null) type = PrincipalType.SdkUnknown("no value provided")
            return this
        }
    }
}
