// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to OneDrive as your data source.
 */
public class OneDriveConfiguration private constructor(builder: Builder) {
    /**
     * `TRUE` to disable local groups information.
     */
    public val disableLocalGroups: kotlin.Boolean = builder.disableLocalGroups
    /**
     * A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
     *
     * The pattern is applied to the file name.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map OneDrive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to OneDrive fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The OneDrive data source field names must exist in your OneDrive custom metadata.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
     *
     * The pattern is applied to the file name.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of user accounts whose documents should be indexed.
     */
    public val oneDriveUsers: aws.sdk.kotlin.services.kendra.model.OneDriveUsers? = builder.oneDriveUsers
    /**
     * The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to connect to OneDrive. The user name should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The Azure Active Directory domain of the organization.
     */
    public val tenantDomain: kotlin.String = requireNotNull(builder.tenantDomain) { "A non-null value must be provided for tenantDomain" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OneDriveConfiguration(")
        append("disableLocalGroups=$disableLocalGroups,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("oneDriveUsers=$oneDriveUsers,")
        append("secretArn=$secretArn,")
        append("tenantDomain=$tenantDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableLocalGroups.hashCode()
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (oneDriveUsers?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (tenantDomain.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OneDriveConfiguration

        if (disableLocalGroups != other.disableLocalGroups) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (oneDriveUsers != other.oneDriveUsers) return false
        if (secretArn != other.secretArn) return false
        if (tenantDomain != other.tenantDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * `TRUE` to disable local groups information.
         */
        public var disableLocalGroups: kotlin.Boolean = false
        /**
         * A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         *
         * The pattern is applied to the file name.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map OneDrive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to OneDrive fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The OneDrive data source field names must exist in your OneDrive custom metadata.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         *
         * The pattern is applied to the file name.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * A list of user accounts whose documents should be indexed.
         */
        public var oneDriveUsers: aws.sdk.kotlin.services.kendra.model.OneDriveUsers? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to connect to OneDrive. The user name should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The Azure Active Directory domain of the organization.
         */
        public var tenantDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration) : this() {
            this.disableLocalGroups = x.disableLocalGroups
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.oneDriveUsers = x.oneDriveUsers
            this.secretArn = x.secretArn
            this.tenantDomain = x.tenantDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = OneDriveConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.OneDriveUsers] inside the given [block]
         */
        public fun oneDriveUsers(block: aws.sdk.kotlin.services.kendra.model.OneDriveUsers.Builder.() -> kotlin.Unit) {
            this.oneDriveUsers = aws.sdk.kotlin.services.kendra.model.OneDriveUsers.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (secretArn == null) secretArn = ""
            if (tenantDomain == null) tenantDomain = ""
            return this
        }
    }
}
