// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to Jira as your data source.
 */
public class JiraConfiguration private constructor(builder: Builder) {
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    public val attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.attachmentFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    public val commentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.commentFieldMappings
    /**
     * A list of regular expression patterns to exclude certain file paths, file names, and file types in your Jira data source. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of regular expression patterns to include certain file paths, file names, and file types in your Jira data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira issues to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    public val issueFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.issueFieldMappings
    /**
     * Specify whether to crawl comments, attachments, and work logs. You can specify one or more of these options.
     */
    public val issueSubEntityFilter: List<IssueSubEntity>? = builder.issueSubEntityFilter
    /**
     * Specify which issue types to crawl in your Jira data source. You can specify one or more of these options to crawl.
     */
    public val issueType: List<String>? = builder.issueType
    /**
     * The URL of the Jira account. For example, *company.atlassian.net*.
     */
    public val jiraAccountUrl: kotlin.String = requireNotNull(builder.jiraAccountUrl) { "A non-null value must be provided for jiraAccountUrl" }
    /**
     * Specify which projects to crawl in your Jira data source. You can specify one or more Jira project IDs.
     */
    public val project: List<String>? = builder.project
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira projects to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    public val projectFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.projectFieldMappings
    /**
     * The Amazon Resource Name (ARN) of a secret in Secrets Manager contains the key-value pairs required to connect to your Jira data source. The secret must contain a JSON structure with the following keys:
     * + jiraId—The Jira user name or email.
     * + jiraCredentials—The Jira API token. For more information, see [Using a Jira data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html).
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * Specify which statuses to crawl in your Jira data source. You can specify one or more of these options to crawl.
     */
    public val status: List<String>? = builder.status
    /**
     * `TRUE` to use the Jira change log to determine which documents require updating in the index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Jira.
     */
    public val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Jira. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira work logs to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    public val workLogFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.workLogFieldMappings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JiraConfiguration(")
        append("attachmentFieldMappings=$attachmentFieldMappings,")
        append("commentFieldMappings=$commentFieldMappings,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("issueFieldMappings=$issueFieldMappings,")
        append("issueSubEntityFilter=$issueSubEntityFilter,")
        append("issueType=$issueType,")
        append("jiraAccountUrl=$jiraAccountUrl,")
        append("project=$project,")
        append("projectFieldMappings=$projectFieldMappings,")
        append("secretArn=$secretArn,")
        append("status=$status,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("workLogFieldMappings=$workLogFieldMappings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (commentFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (issueFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (issueSubEntityFilter?.hashCode() ?: 0)
        result = 31 * result + (issueType?.hashCode() ?: 0)
        result = 31 * result + (jiraAccountUrl.hashCode())
        result = 31 * result + (project?.hashCode() ?: 0)
        result = 31 * result + (projectFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workLogFieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JiraConfiguration

        if (attachmentFieldMappings != other.attachmentFieldMappings) return false
        if (commentFieldMappings != other.commentFieldMappings) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (issueFieldMappings != other.issueFieldMappings) return false
        if (issueSubEntityFilter != other.issueSubEntityFilter) return false
        if (issueType != other.issueType) return false
        if (jiraAccountUrl != other.jiraAccountUrl) return false
        if (project != other.project) return false
        if (projectFieldMappings != other.projectFieldMappings) return false
        if (secretArn != other.secretArn) return false
        if (status != other.status) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (workLogFieldMappings != other.workLogFieldMappings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        public var attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        public var commentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to exclude certain file paths, file names, and file types in your Jira data source. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain file paths, file names, and file types in your Jira data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira issues to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        public var issueFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Specify whether to crawl comments, attachments, and work logs. You can specify one or more of these options.
         */
        public var issueSubEntityFilter: List<IssueSubEntity>? = null
        /**
         * Specify which issue types to crawl in your Jira data source. You can specify one or more of these options to crawl.
         */
        public var issueType: List<String>? = null
        /**
         * The URL of the Jira account. For example, *company.atlassian.net*.
         */
        public var jiraAccountUrl: kotlin.String? = null
        /**
         * Specify which projects to crawl in your Jira data source. You can specify one or more Jira project IDs.
         */
        public var project: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira projects to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        public var projectFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The Amazon Resource Name (ARN) of a secret in Secrets Manager contains the key-value pairs required to connect to your Jira data source. The secret must contain a JSON structure with the following keys:
         * + jiraId—The Jira user name or email.
         * + jiraCredentials—The Jira API token. For more information, see [Using a Jira data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * Specify which statuses to crawl in your Jira data source. You can specify one or more of these options to crawl.
         */
        public var status: List<String>? = null
        /**
         * `TRUE` to use the Jira change log to determine which documents require updating in the index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Jira.
         */
        public var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Jira. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Jira work logs to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        public var workLogFieldMappings: List<DataSourceToIndexFieldMapping>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.JiraConfiguration) : this() {
            this.attachmentFieldMappings = x.attachmentFieldMappings
            this.commentFieldMappings = x.commentFieldMappings
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.issueFieldMappings = x.issueFieldMappings
            this.issueSubEntityFilter = x.issueSubEntityFilter
            this.issueType = x.issueType
            this.jiraAccountUrl = x.jiraAccountUrl
            this.project = x.project
            this.projectFieldMappings = x.projectFieldMappings
            this.secretArn = x.secretArn
            this.status = x.status
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
            this.workLogFieldMappings = x.workLogFieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = JiraConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (jiraAccountUrl == null) jiraAccountUrl = ""
            if (secretArn == null) secretArn = ""
            return this
        }
    }
}
