// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information on the configuration of an index.
 */
public class IndexConfigurationSummary private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the index was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Indicates whether the index is a Enterprise Edition index or a Developer Edition index.
     */
    public val edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = builder.edition
    /**
     * A identifier for the index. Use this to identify the index when you are using APIs such as `Query`, `DescribeIndex`, `UpdateIndex`, and `DeleteIndex`.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the index.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of the index. When the status is `ACTIVE`, the index is ready to search.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.IndexStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Unix timestamp when the index was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexConfigurationSummary(")
        append("createdAt=$createdAt,")
        append("edition=$edition,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexConfigurationSummary

        if (createdAt != other.createdAt) return false
        if (edition != other.edition) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp when the index was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the index is a Enterprise Edition index or a Developer Edition index.
         */
        public var edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = null
        /**
         * A identifier for the index. Use this to identify the index when you are using APIs such as `Query`, `DescribeIndex`, `UpdateIndex`, and `DeleteIndex`.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the index.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the index. When the status is `ACTIVE`, the index is ready to search.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.IndexStatus? = null
        /**
         * The Unix timestamp when the index was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary) : this() {
            this.createdAt = x.createdAt
            this.edition = x.edition
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = IndexConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (status == null) status = IndexStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
