// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to GitHub as your data source.
 *
 * Amazon Kendra now supports an upgraded GitHub connector.
 *
 * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `GitHubConfiguration` object to configure your connector.
 *
 * Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
 *
 * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
 */
public class GitHubConfiguration private constructor(builder: Builder) {
    /**
     * A list of regular expression patterns to exclude certain file names in your GitHub repository or repositories. File names that match the patterns are excluded from the index. File names that don't match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val exclusionFileNamePatterns: List<String>? = builder.exclusionFileNamePatterns
    /**
     * A list of regular expression patterns to exclude certain file types in your GitHub repository or repositories. File types that match the patterns are excluded from the index. File types that don't match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val exclusionFileTypePatterns: List<String>? = builder.exclusionFileTypePatterns
    /**
     * A list of regular expression patterns to exclude certain folder names in your GitHub repository or repositories. Folder names that match the patterns are excluded from the index. Folder names that don't match the patterns are included in the index. If a folder matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
     */
    public val exclusionFolderNamePatterns: List<String>? = builder.exclusionFolderNamePatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub commits to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubCommitConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubCommitConfigurationFieldMappings
    /**
     * Configuration information to include certain types of GitHub content. You can configure to index repository files only, or also include issues and pull requests, comments, and comment attachments.
     */
    public val gitHubDocumentCrawlProperties: aws.sdk.kotlin.services.kendra.model.GitHubDocumentCrawlProperties? = builder.gitHubDocumentCrawlProperties
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issue attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubIssueAttachmentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubIssueAttachmentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issue comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubIssueCommentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubIssueCommentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issues to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubIssueDocumentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubIssueDocumentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull request comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubPullRequestCommentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubPullRequestCommentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull request attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubPullRequestDocumentAttachmentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull requests to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubPullRequestDocumentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubPullRequestDocumentConfigurationFieldMappings
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map GitHub repository attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public val gitHubRepositoryConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.gitHubRepositoryConfigurationFieldMappings
    /**
     * A list of regular expression patterns to include certain file names in your GitHub repository or repositories. File names that match the patterns are included in the index. File names that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val inclusionFileNamePatterns: List<String>? = builder.inclusionFileNamePatterns
    /**
     * A list of regular expression patterns to include certain file types in your GitHub repository or repositories. File types that match the patterns are included in the index. File types that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val inclusionFileTypePatterns: List<String>? = builder.inclusionFileTypePatterns
    /**
     * A list of regular expression patterns to include certain folder names in your GitHub repository or repositories. Folder names that match the patterns are included in the index. Folder names that don't match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
     */
    public val inclusionFolderNamePatterns: List<String>? = builder.inclusionFolderNamePatterns
    /**
     * Configuration information to connect to GitHub Enterprise Server (on premises).
     */
    public val onPremiseConfiguration: aws.sdk.kotlin.services.kendra.model.OnPremiseConfiguration? = builder.onPremiseConfiguration
    /**
     * A list of names of the specific repositories you want to index.
     */
    public val repositoryFilter: List<String>? = builder.repositoryFilter
    /**
     * Configuration information to connect to GitHub Enterprise Cloud (SaaS).
     */
    public val saaSConfiguration: aws.sdk.kotlin.services.kendra.model.SaaSConfiguration? = builder.saaSConfiguration
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your GitHub. The secret must contain a JSON structure with the following keys:
     * + personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see [Using a GitHub data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html).
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server (on premises).
     */
    public val type: aws.sdk.kotlin.services.kendra.model.Type? = builder.type
    /**
     * `TRUE` to use the GitHub change log to determine which documents require updating in the index. Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in GitHub.
     */
    public val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.GitHubConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GitHubConfiguration(")
        append("exclusionFileNamePatterns=$exclusionFileNamePatterns,")
        append("exclusionFileTypePatterns=$exclusionFileTypePatterns,")
        append("exclusionFolderNamePatterns=$exclusionFolderNamePatterns,")
        append("gitHubCommitConfigurationFieldMappings=$gitHubCommitConfigurationFieldMappings,")
        append("gitHubDocumentCrawlProperties=$gitHubDocumentCrawlProperties,")
        append("gitHubIssueAttachmentConfigurationFieldMappings=$gitHubIssueAttachmentConfigurationFieldMappings,")
        append("gitHubIssueCommentConfigurationFieldMappings=$gitHubIssueCommentConfigurationFieldMappings,")
        append("gitHubIssueDocumentConfigurationFieldMappings=$gitHubIssueDocumentConfigurationFieldMappings,")
        append("gitHubPullRequestCommentConfigurationFieldMappings=$gitHubPullRequestCommentConfigurationFieldMappings,")
        append("gitHubPullRequestDocumentAttachmentConfigurationFieldMappings=$gitHubPullRequestDocumentAttachmentConfigurationFieldMappings,")
        append("gitHubPullRequestDocumentConfigurationFieldMappings=$gitHubPullRequestDocumentConfigurationFieldMappings,")
        append("gitHubRepositoryConfigurationFieldMappings=$gitHubRepositoryConfigurationFieldMappings,")
        append("inclusionFileNamePatterns=$inclusionFileNamePatterns,")
        append("inclusionFileTypePatterns=$inclusionFileTypePatterns,")
        append("inclusionFolderNamePatterns=$inclusionFolderNamePatterns,")
        append("onPremiseConfiguration=$onPremiseConfiguration,")
        append("repositoryFilter=$repositoryFilter,")
        append("saaSConfiguration=$saaSConfiguration,")
        append("secretArn=$secretArn,")
        append("type=$type,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusionFileNamePatterns?.hashCode() ?: 0
        result = 31 * result + (exclusionFileTypePatterns?.hashCode() ?: 0)
        result = 31 * result + (exclusionFolderNamePatterns?.hashCode() ?: 0)
        result = 31 * result + (gitHubCommitConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubDocumentCrawlProperties?.hashCode() ?: 0)
        result = 31 * result + (gitHubIssueAttachmentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubIssueCommentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubIssueDocumentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubPullRequestCommentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubPullRequestDocumentAttachmentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubPullRequestDocumentConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (gitHubRepositoryConfigurationFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionFileNamePatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionFileTypePatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionFolderNamePatterns?.hashCode() ?: 0)
        result = 31 * result + (onPremiseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (repositoryFilter?.hashCode() ?: 0)
        result = 31 * result + (saaSConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GitHubConfiguration

        if (exclusionFileNamePatterns != other.exclusionFileNamePatterns) return false
        if (exclusionFileTypePatterns != other.exclusionFileTypePatterns) return false
        if (exclusionFolderNamePatterns != other.exclusionFolderNamePatterns) return false
        if (gitHubCommitConfigurationFieldMappings != other.gitHubCommitConfigurationFieldMappings) return false
        if (gitHubDocumentCrawlProperties != other.gitHubDocumentCrawlProperties) return false
        if (gitHubIssueAttachmentConfigurationFieldMappings != other.gitHubIssueAttachmentConfigurationFieldMappings) return false
        if (gitHubIssueCommentConfigurationFieldMappings != other.gitHubIssueCommentConfigurationFieldMappings) return false
        if (gitHubIssueDocumentConfigurationFieldMappings != other.gitHubIssueDocumentConfigurationFieldMappings) return false
        if (gitHubPullRequestCommentConfigurationFieldMappings != other.gitHubPullRequestCommentConfigurationFieldMappings) return false
        if (gitHubPullRequestDocumentAttachmentConfigurationFieldMappings != other.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) return false
        if (gitHubPullRequestDocumentConfigurationFieldMappings != other.gitHubPullRequestDocumentConfigurationFieldMappings) return false
        if (gitHubRepositoryConfigurationFieldMappings != other.gitHubRepositoryConfigurationFieldMappings) return false
        if (inclusionFileNamePatterns != other.inclusionFileNamePatterns) return false
        if (inclusionFileTypePatterns != other.inclusionFileTypePatterns) return false
        if (inclusionFolderNamePatterns != other.inclusionFolderNamePatterns) return false
        if (onPremiseConfiguration != other.onPremiseConfiguration) return false
        if (repositoryFilter != other.repositoryFilter) return false
        if (saaSConfiguration != other.saaSConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (type != other.type) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.GitHubConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of regular expression patterns to exclude certain file names in your GitHub repository or repositories. File names that match the patterns are excluded from the index. File names that don't match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var exclusionFileNamePatterns: List<String>? = null
        /**
         * A list of regular expression patterns to exclude certain file types in your GitHub repository or repositories. File types that match the patterns are excluded from the index. File types that don't match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var exclusionFileTypePatterns: List<String>? = null
        /**
         * A list of regular expression patterns to exclude certain folder names in your GitHub repository or repositories. Folder names that match the patterns are excluded from the index. Folder names that don't match the patterns are included in the index. If a folder matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         */
        public var exclusionFolderNamePatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub commits to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubCommitConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Configuration information to include certain types of GitHub content. You can configure to index repository files only, or also include issues and pull requests, comments, and comment attachments.
         */
        public var gitHubDocumentCrawlProperties: aws.sdk.kotlin.services.kendra.model.GitHubDocumentCrawlProperties? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issue attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubIssueAttachmentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issue comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubIssueCommentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub issues to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubIssueDocumentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull request comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubPullRequestCommentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull request attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubPullRequestDocumentAttachmentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of GitHub pull requests to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubPullRequestDocumentConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map GitHub repository attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to GitHub fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The GitHub data source field names must exist in your GitHub custom metadata.
         */
        public var gitHubRepositoryConfigurationFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain file names in your GitHub repository or repositories. File names that match the patterns are included in the index. File names that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var inclusionFileNamePatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain file types in your GitHub repository or repositories. File types that match the patterns are included in the index. File types that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var inclusionFileTypePatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain folder names in your GitHub repository or repositories. Folder names that match the patterns are included in the index. Folder names that don't match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         */
        public var inclusionFolderNamePatterns: List<String>? = null
        /**
         * Configuration information to connect to GitHub Enterprise Server (on premises).
         */
        public var onPremiseConfiguration: aws.sdk.kotlin.services.kendra.model.OnPremiseConfiguration? = null
        /**
         * A list of names of the specific repositories you want to index.
         */
        public var repositoryFilter: List<String>? = null
        /**
         * Configuration information to connect to GitHub Enterprise Cloud (SaaS).
         */
        public var saaSConfiguration: aws.sdk.kotlin.services.kendra.model.SaaSConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your GitHub. The secret must contain a JSON structure with the following keys:
         * + personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see [Using a GitHub data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server (on premises).
         */
        public var type: aws.sdk.kotlin.services.kendra.model.Type? = null
        /**
         * `TRUE` to use the GitHub change log to determine which documents require updating in the index. Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in GitHub.
         */
        public var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.GitHubConfiguration) : this() {
            this.exclusionFileNamePatterns = x.exclusionFileNamePatterns
            this.exclusionFileTypePatterns = x.exclusionFileTypePatterns
            this.exclusionFolderNamePatterns = x.exclusionFolderNamePatterns
            this.gitHubCommitConfigurationFieldMappings = x.gitHubCommitConfigurationFieldMappings
            this.gitHubDocumentCrawlProperties = x.gitHubDocumentCrawlProperties
            this.gitHubIssueAttachmentConfigurationFieldMappings = x.gitHubIssueAttachmentConfigurationFieldMappings
            this.gitHubIssueCommentConfigurationFieldMappings = x.gitHubIssueCommentConfigurationFieldMappings
            this.gitHubIssueDocumentConfigurationFieldMappings = x.gitHubIssueDocumentConfigurationFieldMappings
            this.gitHubPullRequestCommentConfigurationFieldMappings = x.gitHubPullRequestCommentConfigurationFieldMappings
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = x.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
            this.gitHubPullRequestDocumentConfigurationFieldMappings = x.gitHubPullRequestDocumentConfigurationFieldMappings
            this.gitHubRepositoryConfigurationFieldMappings = x.gitHubRepositoryConfigurationFieldMappings
            this.inclusionFileNamePatterns = x.inclusionFileNamePatterns
            this.inclusionFileTypePatterns = x.inclusionFileTypePatterns
            this.inclusionFolderNamePatterns = x.inclusionFolderNamePatterns
            this.onPremiseConfiguration = x.onPremiseConfiguration
            this.repositoryFilter = x.repositoryFilter
            this.saaSConfiguration = x.saaSConfiguration
            this.secretArn = x.secretArn
            this.type = x.type
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.GitHubConfiguration = GitHubConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.GitHubDocumentCrawlProperties] inside the given [block]
         */
        public fun gitHubDocumentCrawlProperties(block: aws.sdk.kotlin.services.kendra.model.GitHubDocumentCrawlProperties.Builder.() -> kotlin.Unit) {
            this.gitHubDocumentCrawlProperties = aws.sdk.kotlin.services.kendra.model.GitHubDocumentCrawlProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.OnPremiseConfiguration] inside the given [block]
         */
        public fun onPremiseConfiguration(block: aws.sdk.kotlin.services.kendra.model.OnPremiseConfiguration.Builder.() -> kotlin.Unit) {
            this.onPremiseConfiguration = aws.sdk.kotlin.services.kendra.model.OnPremiseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SaaSConfiguration] inside the given [block]
         */
        public fun saaSConfiguration(block: aws.sdk.kotlin.services.kendra.model.SaaSConfiguration.Builder.() -> kotlin.Unit) {
            this.saaSConfiguration = aws.sdk.kotlin.services.kendra.model.SaaSConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (secretArn == null) secretArn = ""
            return this
        }
    }
}
