// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetSnapshotsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the index to get search metrics data.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:
     * + `THIS_WEEK`: The current week, starting on the Sunday and ending on the day before the current date.
     * + `ONE_WEEK_AGO`: The previous week, starting on the Sunday and ending on the following Saturday.
     * + `TWO_WEEKS_AGO`: The week before the previous week, starting on the Sunday and ending on the following Saturday.
     * + `THIS_MONTH`: The current month, starting on the first day of the month and ending on the day before the current date.
     * + `ONE_MONTH_AGO`: The previous month, starting on the first day of the month and ending on the last day of the month.
     * + `TWO_MONTHS_AGO`: The month before the previous month, starting on the first day of the month and ending on last day of the month.
     */
    public val interval: aws.sdk.kotlin.services.kendra.model.Interval? = builder.interval
    /**
     * The maximum number of returned data for the metric.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The metric you want to retrieve. You can specify only one metric per call.
     *
     * For more information about the metrics you can view, see [Gaining insights with search analytics](https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html).
     */
    public val metricType: aws.sdk.kotlin.services.kendra.model.MetricType? = builder.metricType
    /**
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSnapshotsRequest(")
        append("indexId=$indexId,")
        append("interval=$interval,")
        append("maxResults=$maxResults,")
        append("metricType=$metricType,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexId?.hashCode() ?: 0
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metricType?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSnapshotsRequest

        if (indexId != other.indexId) return false
        if (interval != other.interval) return false
        if (maxResults != other.maxResults) return false
        if (metricType != other.metricType) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the index to get search metrics data.
         */
        public var indexId: kotlin.String? = null
        /**
         * The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:
         * + `THIS_WEEK`: The current week, starting on the Sunday and ending on the day before the current date.
         * + `ONE_WEEK_AGO`: The previous week, starting on the Sunday and ending on the following Saturday.
         * + `TWO_WEEKS_AGO`: The week before the previous week, starting on the Sunday and ending on the following Saturday.
         * + `THIS_MONTH`: The current month, starting on the first day of the month and ending on the day before the current date.
         * + `ONE_MONTH_AGO`: The previous month, starting on the first day of the month and ending on the last day of the month.
         * + `TWO_MONTHS_AGO`: The month before the previous month, starting on the first day of the month and ending on last day of the month.
         */
        public var interval: aws.sdk.kotlin.services.kendra.model.Interval? = null
        /**
         * The maximum number of returned data for the metric.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The metric you want to retrieve. You can specify only one metric per call.
         *
         * For more information about the metrics you can view, see [Gaining insights with search analytics](https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html).
         */
        public var metricType: aws.sdk.kotlin.services.kendra.model.MetricType? = null
        /**
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest) : this() {
            this.indexId = x.indexId
            this.interval = x.interval
            this.maxResults = x.maxResults
            this.metricType = x.metricType
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest = GetSnapshotsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
