// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A set of featured results that are displayed at the top of your search results. Featured results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
 */
public class FeaturedResultsSet private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the set of featured results was created.
     */
    public val creationTimestamp: kotlin.Long? = builder.creationTimestamp
    /**
     * The description for the set of featured results.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of document IDs for the documents you want to feature at the top of the search results page. You can use the [Query](https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html) API to search for specific documents with their document IDs included in the result items, or you can use the console.
     *
     * You can add up to four featured documents. You can request to increase this limit by contacting [Support](http://aws.amazon.com/contact-us/).
     *
     * Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify 'Kendra', queries such as 'How does kendra semantically rank results?' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.
     */
    public val featuredDocuments: List<FeaturedDocument>? = builder.featuredDocuments
    /**
     * The identifier of the set of featured results.
     */
    public val featuredResultsSetId: kotlin.String? = builder.featuredResultsSetId
    /**
     * The name for the set of featured results.
     */
    public val featuredResultsSetName: kotlin.String? = builder.featuredResultsSetName
    /**
     * The Unix timestamp when the set of featured results was last updated.
     */
    public val lastUpdatedTimestamp: kotlin.Long? = builder.lastUpdatedTimestamp
    /**
     * The list of queries for featuring results.
     *
     * Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify 'Kendra', queries such as 'How does kendra semantically rank results?' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.
     */
    public val queryTexts: List<String>? = builder.queryTexts
    /**
     * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturedResultsSet(")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("featuredDocuments=$featuredDocuments,")
        append("featuredResultsSetId=$featuredResultsSetId,")
        append("featuredResultsSetName=$featuredResultsSetName,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("queryTexts=$queryTexts,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (featuredDocuments?.hashCode() ?: 0)
        result = 31 * result + (featuredResultsSetId?.hashCode() ?: 0)
        result = 31 * result + (featuredResultsSetName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (queryTexts?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturedResultsSet

        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (featuredDocuments != other.featuredDocuments) return false
        if (featuredResultsSetId != other.featuredResultsSetId) return false
        if (featuredResultsSetName != other.featuredResultsSetName) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (queryTexts != other.queryTexts) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp when the set of featured results was created.
         */
        public var creationTimestamp: kotlin.Long? = null
        /**
         * The description for the set of featured results.
         */
        public var description: kotlin.String? = null
        /**
         * The list of document IDs for the documents you want to feature at the top of the search results page. You can use the [Query](https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html) API to search for specific documents with their document IDs included in the result items, or you can use the console.
         *
         * You can add up to four featured documents. You can request to increase this limit by contacting [Support](http://aws.amazon.com/contact-us/).
         *
         * Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify 'Kendra', queries such as 'How does kendra semantically rank results?' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.
         */
        public var featuredDocuments: List<FeaturedDocument>? = null
        /**
         * The identifier of the set of featured results.
         */
        public var featuredResultsSetId: kotlin.String? = null
        /**
         * The name for the set of featured results.
         */
        public var featuredResultsSetName: kotlin.String? = null
        /**
         * The Unix timestamp when the set of featured results was last updated.
         */
        public var lastUpdatedTimestamp: kotlin.Long? = null
        /**
         * The list of queries for featuring results.
         *
         * Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify 'Kendra', queries such as 'How does kendra semantically rank results?' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.
         */
        public var queryTexts: List<String>? = null
        /**
         * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSet) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.featuredDocuments = x.featuredDocuments
            this.featuredResultsSetId = x.featuredResultsSetId
            this.featuredResultsSetName = x.featuredResultsSetName
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.queryTexts = x.queryTexts
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSet = FeaturedResultsSet(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
