// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single featured result item. A featured result is displayed at the top of the search results page, placed above all other results for certain queries. If there's an exact match of a query, then certain documents are featured in the search results.
 */
public class FeaturedResultsItem private constructor(builder: Builder) {
    /**
     * One or more additional attributes associated with the featured result.
     */
    public val additionalAttributes: List<AdditionalResultAttribute>? = builder.additionalAttributes
    /**
     * An array of document attributes assigned to a featured document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
     */
    public val documentAttributes: List<DocumentAttribute>? = builder.documentAttributes
    /**
     * Provides text and information about where to highlight the text.
     */
    public val documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentExcerpt
    /**
     * The identifier of the featured document.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * Provides text and information about where to highlight the text.
     */
    public val documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentTitle
    /**
     * The source URI location of the featured document.
     */
    public val documentUri: kotlin.String? = builder.documentUri
    /**
     * A token that identifies a particular featured result from a particular query. Use this token to provide click-through feedback for the result. For more information, see [Submitting feedback](https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
     */
    public val feedbackToken: kotlin.String? = builder.feedbackToken
    /**
     * The identifier of the featured result.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The type of document within the featured result response. For example, a response could include a question-answer type that's relevant to the query.
     */
    public val type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FeaturedResultsItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturedResultsItem(")
        append("additionalAttributes=$additionalAttributes,")
        append("documentAttributes=$documentAttributes,")
        append("documentExcerpt=$documentExcerpt,")
        append("documentId=$documentId,")
        append("documentTitle=$documentTitle,")
        append("documentUri=$documentUri,")
        append("feedbackToken=$feedbackToken,")
        append("id=$id,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (documentAttributes?.hashCode() ?: 0)
        result = 31 * result + (documentExcerpt?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (documentTitle?.hashCode() ?: 0)
        result = 31 * result + (documentUri?.hashCode() ?: 0)
        result = 31 * result + (feedbackToken?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturedResultsItem

        if (additionalAttributes != other.additionalAttributes) return false
        if (documentAttributes != other.documentAttributes) return false
        if (documentExcerpt != other.documentExcerpt) return false
        if (documentId != other.documentId) return false
        if (documentTitle != other.documentTitle) return false
        if (documentUri != other.documentUri) return false
        if (feedbackToken != other.feedbackToken) return false
        if (id != other.id) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FeaturedResultsItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One or more additional attributes associated with the featured result.
         */
        public var additionalAttributes: List<AdditionalResultAttribute>? = null
        /**
         * An array of document attributes assigned to a featured document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
         */
        public var documentAttributes: List<DocumentAttribute>? = null
        /**
         * Provides text and information about where to highlight the text.
         */
        public var documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The identifier of the featured document.
         */
        public var documentId: kotlin.String? = null
        /**
         * Provides text and information about where to highlight the text.
         */
        public var documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The source URI location of the featured document.
         */
        public var documentUri: kotlin.String? = null
        /**
         * A token that identifies a particular featured result from a particular query. Use this token to provide click-through feedback for the result. For more information, see [Submitting feedback](https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
         */
        public var feedbackToken: kotlin.String? = null
        /**
         * The identifier of the featured result.
         */
        public var id: kotlin.String? = null
        /**
         * The type of document within the featured result response. For example, a response could include a question-answer type that's relevant to the query.
         */
        public var type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FeaturedResultsItem) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.documentAttributes = x.documentAttributes
            this.documentExcerpt = x.documentExcerpt
            this.documentId = x.documentId
            this.documentTitle = x.documentTitle
            this.documentUri = x.documentUri
            this.feedbackToken = x.feedbackToken
            this.id = x.id
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FeaturedResultsItem = FeaturedResultsItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentExcerpt(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentExcerpt = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentTitle(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentTitle = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
