// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for frequently asked questions and answers included in an index.
 */
public class FaqSummary private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the FAQ was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The file type used to create the FAQ.
     */
    public val fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = builder.fileFormat
    /**
     * The identifier of the FAQ.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    public val languageCode: kotlin.String? = builder.languageCode
    /**
     * The name that you assigned the FAQ when you created or updated the FAQ.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of the FAQ. When the status is `ACTIVE` the FAQ is ready for use.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.FaqStatus? = builder.status
    /**
     * The Unix timestamp when the FAQ was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FaqSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FaqSummary(")
        append("createdAt=$createdAt,")
        append("fileFormat=$fileFormat,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (fileFormat?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FaqSummary

        if (createdAt != other.createdAt) return false
        if (fileFormat != other.fileFormat) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FaqSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp when the FAQ was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The file type used to create the FAQ.
         */
        public var fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = null
        /**
         * The identifier of the FAQ.
         */
        public var id: kotlin.String? = null
        /**
         * The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
         */
        public var languageCode: kotlin.String? = null
        /**
         * The name that you assigned the FAQ when you created or updated the FAQ.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the FAQ. When the status is `ACTIVE` the FAQ is ready for use.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.FaqStatus? = null
        /**
         * The Unix timestamp when the FAQ was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FaqSummary) : this() {
            this.createdAt = x.createdAt
            this.fileFormat = x.fileFormat
            this.id = x.id
            this.languageCode = x.languageCode
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FaqSummary = FaqSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
