// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single expanded result in a collapsed group of search results.
 *
 * An expanded result item contains information about an expanded result document within a collapsed group of search results. This includes the original location of the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the query.
 */
public class ExpandedResultItem private constructor(builder: Builder) {
    /**
     * An array of document attributes assigned to a document in the search results. For example, the document author ("_author") or the source URI ("_source_uri") of the document.
     */
    public val documentAttributes: List<DocumentAttribute>? = builder.documentAttributes
    /**
     * Provides text and information about where to highlight the text.
     */
    public val documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentExcerpt
    /**
     * The idenitifier of the document.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * Provides text and information about where to highlight the text.
     */
    public val documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentTitle
    /**
     * The URI of the original location of the document.
     */
    public val documentUri: kotlin.String? = builder.documentUri
    /**
     * The identifier for the expanded result.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ExpandedResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExpandedResultItem(")
        append("documentAttributes=$documentAttributes,")
        append("documentExcerpt=$documentExcerpt,")
        append("documentId=$documentId,")
        append("documentTitle=$documentTitle,")
        append("documentUri=$documentUri,")
        append("id=$id")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentAttributes?.hashCode() ?: 0
        result = 31 * result + (documentExcerpt?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (documentTitle?.hashCode() ?: 0)
        result = 31 * result + (documentUri?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExpandedResultItem

        if (documentAttributes != other.documentAttributes) return false
        if (documentExcerpt != other.documentExcerpt) return false
        if (documentId != other.documentId) return false
        if (documentTitle != other.documentTitle) return false
        if (documentUri != other.documentUri) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ExpandedResultItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of document attributes assigned to a document in the search results. For example, the document author ("_author") or the source URI ("_source_uri") of the document.
         */
        public var documentAttributes: List<DocumentAttribute>? = null
        /**
         * Provides text and information about where to highlight the text.
         */
        public var documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The idenitifier of the document.
         */
        public var documentId: kotlin.String? = null
        /**
         * Provides text and information about where to highlight the text.
         */
        public var documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The URI of the original location of the document.
         */
        public var documentUri: kotlin.String? = null
        /**
         * The identifier for the expanded result.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ExpandedResultItem) : this() {
            this.documentAttributes = x.documentAttributes
            this.documentExcerpt = x.documentExcerpt
            this.documentId = x.documentId
            this.documentTitle = x.documentTitle
            this.documentUri = x.documentUri
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ExpandedResultItem = ExpandedResultItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentExcerpt(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentExcerpt = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentTitle(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentTitle = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
