// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration information needed to customize how collapsed search result groups expand.
 */
public class ExpandConfiguration private constructor(builder: Builder) {
    /**
     * The number of expanded results to show per collapsed primary document. For instance, if you set this value to 3, then at most 3 results per collapsed group will be displayed.
     */
    public val maxExpandedResultsPerItem: kotlin.Int? = builder.maxExpandedResultsPerItem
    /**
     * The number of collapsed search result groups to expand. If you set this value to 10, for example, only the first 10 out of 100 result groups will have expand functionality.
     */
    public val maxResultItemsToExpand: kotlin.Int? = builder.maxResultItemsToExpand

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ExpandConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExpandConfiguration(")
        append("maxExpandedResultsPerItem=$maxExpandedResultsPerItem,")
        append("maxResultItemsToExpand=$maxResultItemsToExpand")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxExpandedResultsPerItem ?: 0
        result = 31 * result + (maxResultItemsToExpand ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExpandConfiguration

        if (maxExpandedResultsPerItem != other.maxExpandedResultsPerItem) return false
        if (maxResultItemsToExpand != other.maxResultItemsToExpand) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ExpandConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of expanded results to show per collapsed primary document. For instance, if you set this value to 3, then at most 3 results per collapsed group will be displayed.
         */
        public var maxExpandedResultsPerItem: kotlin.Int? = null
        /**
         * The number of collapsed search result groups to expand. If you set this value to 10, for example, only the first 10 out of 100 result groups will have expand functionality.
         */
        public var maxResultItemsToExpand: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ExpandConfiguration) : this() {
            this.maxExpandedResultsPerItem = x.maxExpandedResultsPerItem
            this.maxResultItemsToExpand = x.maxResultItemsToExpand
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ExpandConfiguration = ExpandConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
