// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the properties, such as relevance tuning and searchability, of an index field.
 */
public class DocumentMetadataConfiguration private constructor(builder: Builder) {
    /**
     * The name of the index field.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Provides tuning parameters to determine how the field affects the search results.
     */
    public val relevance: aws.sdk.kotlin.services.kendra.model.Relevance? = builder.relevance
    /**
     * Provides information about how the field is used during a search.
     */
    public val search: aws.sdk.kotlin.services.kendra.model.Search? = builder.search
    /**
     * The data type of the index field.
     */
    public val type: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DocumentMetadataConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentMetadataConfiguration(")
        append("name=$name,")
        append("relevance=$relevance,")
        append("search=$search,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (relevance?.hashCode() ?: 0)
        result = 31 * result + (search?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentMetadataConfiguration

        if (name != other.name) return false
        if (relevance != other.relevance) return false
        if (search != other.search) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DocumentMetadataConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the index field.
         */
        public var name: kotlin.String? = null
        /**
         * Provides tuning parameters to determine how the field affects the search results.
         */
        public var relevance: aws.sdk.kotlin.services.kendra.model.Relevance? = null
        /**
         * Provides information about how the field is used during a search.
         */
        public var search: aws.sdk.kotlin.services.kendra.model.Search? = null
        /**
         * The data type of the index field.
         */
        public var type: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DocumentMetadataConfiguration) : this() {
            this.name = x.name
            this.relevance = x.relevance
            this.search = x.search
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DocumentMetadataConfiguration = DocumentMetadataConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.Relevance] inside the given [block]
         */
        public fun relevance(block: aws.sdk.kotlin.services.kendra.model.Relevance.Builder.() -> kotlin.Unit) {
            this.relevance = aws.sdk.kotlin.services.kendra.model.Relevance.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.Search] inside the given [block]
         */
        public fun search(block: aws.sdk.kotlin.services.kendra.model.Search.Builder.() -> kotlin.Unit) {
            this.search = aws.sdk.kotlin.services.kendra.model.Search.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = DocumentAttributeValueType.SdkUnknown("no value provided")
            return this
        }
    }
}
