// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifies a document for which to retrieve status information
 */
public class DocumentInfo private constructor(builder: Builder) {
    /**
     * Attributes that identify a specific version of a document to check.
     *
     * The only valid attributes are:
     * + version
     * + datasourceId
     * + jobExecutionId
     *
     * The attributes follow these rules:
     * + `dataSourceId` and `jobExecutionId` must be used together.
     * + `version` is ignored if `dataSourceId` and `jobExecutionId` are not provided.
     * + If `dataSourceId` and `jobExecutionId` are provided, but `version` is not, the version defaults to "0".
     */
    public val attributes: List<DocumentAttribute>? = builder.attributes
    /**
     * The identifier of the document.
     */
    public val documentId: kotlin.String = requireNotNull(builder.documentId) { "A non-null value must be provided for documentId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DocumentInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentInfo(")
        append("attributes=$attributes,")
        append("documentId=$documentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (documentId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentInfo

        if (attributes != other.attributes) return false
        if (documentId != other.documentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DocumentInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Attributes that identify a specific version of a document to check.
         *
         * The only valid attributes are:
         * + version
         * + datasourceId
         * + jobExecutionId
         *
         * The attributes follow these rules:
         * + `dataSourceId` and `jobExecutionId` must be used together.
         * + `version` is ignored if `dataSourceId` and `jobExecutionId` are not provided.
         * + If `dataSourceId` and `jobExecutionId` are provided, but `version` is not, the version defaults to "0".
         */
        public var attributes: List<DocumentAttribute>? = null
        /**
         * The identifier of the document.
         */
        public var documentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DocumentInfo) : this() {
            this.attributes = x.attributes
            this.documentId = x.documentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DocumentInfo = DocumentInfo(this)

        internal fun correctErrors(): Builder {
            if (documentId == null) documentId = ""
            return this
        }
    }
}
