// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the count of documents that match a particular document attribute or field when doing a faceted search.
 */
public class DocumentAttributeValueCountPair private constructor(builder: Builder) {
    /**
     * The number of documents in the response that have the attribute/field value for the key.
     */
    public val count: kotlin.Int? = builder.count
    /**
     * The value of the attribute/field. For example, "HR".
     */
    public val documentAttributeValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = builder.documentAttributeValue
    /**
     * Contains the results of a document attribute/field that is a nested facet. A `FacetResult` contains the counts for each facet nested within a facet.
     *
     * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. The counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.
     */
    public val facetResults: List<FacetResult>? = builder.facetResults

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueCountPair = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeValueCountPair(")
        append("count=$count,")
        append("documentAttributeValue=$documentAttributeValue,")
        append("facetResults=$facetResults")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = count ?: 0
        result = 31 * result + (documentAttributeValue?.hashCode() ?: 0)
        result = 31 * result + (facetResults?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeValueCountPair

        if (count != other.count) return false
        if (documentAttributeValue != other.documentAttributeValue) return false
        if (facetResults != other.facetResults) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueCountPair = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of documents in the response that have the attribute/field value for the key.
         */
        public var count: kotlin.Int? = null
        /**
         * The value of the attribute/field. For example, "HR".
         */
        public var documentAttributeValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = null
        /**
         * Contains the results of a document attribute/field that is a nested facet. A `FacetResult` contains the counts for each facet nested within a facet.
         *
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. The counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.
         */
        public var facetResults: List<FacetResult>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueCountPair) : this() {
            this.count = x.count
            this.documentAttributeValue = x.documentAttributeValue
            this.facetResults = x.facetResults
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DocumentAttributeValueCountPair = DocumentAttributeValueCountPair(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue] inside the given [block]
         */
        public fun documentAttributeValue(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.Builder.() -> kotlin.Unit) {
            this.documentAttributeValue = aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
