// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeQuerySuggestionsConfigResponse private constructor(builder: Builder) {
    /**
     * Configuration information for the document fields/attributes that you want to base query suggestions on.
     */
    public val attributeSuggestionsConfig: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig? = builder.attributeSuggestionsConfig
    /**
     * `TRUE` to use all queries, otherwise use only queries that include user information to generate the query suggestions.
     */
    public val includeQueriesWithoutUserInformation: kotlin.Boolean? = builder.includeQueriesWithoutUserInformation
    /**
     * The Unix timestamp when query suggestions for an index was last cleared.
     *
     * After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time you cleared suggestions.
     */
    public val lastClearTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastClearTime
    /**
     * The Unix timestamp when query suggestions for an index was last updated.
     *
     * Amazon Kendra automatically updates suggestions every 24 hours, after you change a setting or after you apply a [block list](https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist).
     */
    public val lastSuggestionsBuildTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuggestionsBuildTime
    /**
     * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
     */
    public val minimumNumberOfQueryingUsers: kotlin.Int? = builder.minimumNumberOfQueryingUsers
    /**
     * The minimum number of times a query must be searched in order for the query to be eligible to suggest to your users.
     */
    public val minimumQueryCount: kotlin.Int? = builder.minimumQueryCount
    /**
     * Whether query suggestions are currently in `ENABLED` mode or `LEARN_ONLY` mode.
     *
     * By default, Amazon Kendra enables query suggestions.`LEARN_ONLY` turns off query suggestions for your users. You can change the mode using the [UpdateQuerySuggestionsConfig](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html) API.
     */
    public val mode: aws.sdk.kotlin.services.kendra.model.Mode? = builder.mode
    /**
     * How recent your queries are in your query log time window (in days).
     */
    public val queryLogLookBackWindowInDays: kotlin.Int? = builder.queryLogLookBackWindowInDays
    /**
     * Whether the status of query suggestions settings is currently `ACTIVE` or `UPDATING`.
     *
     * Active means the current settings apply and Updating means your changed settings are in the process of applying.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus? = builder.status
    /**
     * The current total count of query suggestions for an index.
     *
     * This count can change when you update your query suggestions settings, if you filter out certain queries from suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn from.
     *
     * If the count is much lower than you expected, it could be because Amazon Kendra needs more queries in the query history to learn from or your current query suggestions settings are too strict.
     */
    public val totalSuggestionsCount: kotlin.Int? = builder.totalSuggestionsCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeQuerySuggestionsConfigResponse(")
        append("attributeSuggestionsConfig=$attributeSuggestionsConfig,")
        append("includeQueriesWithoutUserInformation=$includeQueriesWithoutUserInformation,")
        append("lastClearTime=$lastClearTime,")
        append("lastSuggestionsBuildTime=$lastSuggestionsBuildTime,")
        append("minimumNumberOfQueryingUsers=$minimumNumberOfQueryingUsers,")
        append("minimumQueryCount=$minimumQueryCount,")
        append("mode=$mode,")
        append("queryLogLookBackWindowInDays=$queryLogLookBackWindowInDays,")
        append("status=$status,")
        append("totalSuggestionsCount=$totalSuggestionsCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeSuggestionsConfig?.hashCode() ?: 0
        result = 31 * result + (includeQueriesWithoutUserInformation?.hashCode() ?: 0)
        result = 31 * result + (lastClearTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuggestionsBuildTime?.hashCode() ?: 0)
        result = 31 * result + (minimumNumberOfQueryingUsers ?: 0)
        result = 31 * result + (minimumQueryCount ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (queryLogLookBackWindowInDays ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalSuggestionsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeQuerySuggestionsConfigResponse

        if (attributeSuggestionsConfig != other.attributeSuggestionsConfig) return false
        if (includeQueriesWithoutUserInformation != other.includeQueriesWithoutUserInformation) return false
        if (lastClearTime != other.lastClearTime) return false
        if (lastSuggestionsBuildTime != other.lastSuggestionsBuildTime) return false
        if (minimumNumberOfQueryingUsers != other.minimumNumberOfQueryingUsers) return false
        if (minimumQueryCount != other.minimumQueryCount) return false
        if (mode != other.mode) return false
        if (queryLogLookBackWindowInDays != other.queryLogLookBackWindowInDays) return false
        if (status != other.status) return false
        if (totalSuggestionsCount != other.totalSuggestionsCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration information for the document fields/attributes that you want to base query suggestions on.
         */
        public var attributeSuggestionsConfig: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig? = null
        /**
         * `TRUE` to use all queries, otherwise use only queries that include user information to generate the query suggestions.
         */
        public var includeQueriesWithoutUserInformation: kotlin.Boolean? = null
        /**
         * The Unix timestamp when query suggestions for an index was last cleared.
         *
         * After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time you cleared suggestions.
         */
        public var lastClearTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix timestamp when query suggestions for an index was last updated.
         *
         * Amazon Kendra automatically updates suggestions every 24 hours, after you change a setting or after you apply a [block list](https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist).
         */
        public var lastSuggestionsBuildTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
         */
        public var minimumNumberOfQueryingUsers: kotlin.Int? = null
        /**
         * The minimum number of times a query must be searched in order for the query to be eligible to suggest to your users.
         */
        public var minimumQueryCount: kotlin.Int? = null
        /**
         * Whether query suggestions are currently in `ENABLED` mode or `LEARN_ONLY` mode.
         *
         * By default, Amazon Kendra enables query suggestions.`LEARN_ONLY` turns off query suggestions for your users. You can change the mode using the [UpdateQuerySuggestionsConfig](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html) API.
         */
        public var mode: aws.sdk.kotlin.services.kendra.model.Mode? = null
        /**
         * How recent your queries are in your query log time window (in days).
         */
        public var queryLogLookBackWindowInDays: kotlin.Int? = null
        /**
         * Whether the status of query suggestions settings is currently `ACTIVE` or `UPDATING`.
         *
         * Active means the current settings apply and Updating means your changed settings are in the process of applying.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus? = null
        /**
         * The current total count of query suggestions for an index.
         *
         * This count can change when you update your query suggestions settings, if you filter out certain queries from suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn from.
         *
         * If the count is much lower than you expected, it could be because Amazon Kendra needs more queries in the query history to learn from or your current query suggestions settings are too strict.
         */
        public var totalSuggestionsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse) : this() {
            this.attributeSuggestionsConfig = x.attributeSuggestionsConfig
            this.includeQueriesWithoutUserInformation = x.includeQueriesWithoutUserInformation
            this.lastClearTime = x.lastClearTime
            this.lastSuggestionsBuildTime = x.lastSuggestionsBuildTime
            this.minimumNumberOfQueryingUsers = x.minimumNumberOfQueryingUsers
            this.minimumQueryCount = x.minimumQueryCount
            this.mode = x.mode
            this.queryLogLookBackWindowInDays = x.queryLogLookBackWindowInDays
            this.status = x.status
            this.totalSuggestionsCount = x.totalSuggestionsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = DescribeQuerySuggestionsConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig] inside the given [block]
         */
        public fun attributeSuggestionsConfig(block: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig.Builder.() -> kotlin.Unit) {
            this.attributeSuggestionsConfig = aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
