// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Maps attributes or field names of the documents synced from the data source to Amazon Kendra index field names. You can set up field mappings for each data source when calling [CreateDataSource](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateDataSource.html) or [UpdateDataSource](https://docs.aws.amazon.com/kendra/latest/APIReference/API_UpdateDataSource.html) API. To create custom fields, use the `UpdateIndex` API to first create an index field and then map to the data source field. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
 */
public class DataSourceToIndexFieldMapping private constructor(builder: Builder) {
    /**
     * The name of the field in the data source. You must first create the index field using the `UpdateIndex` API.
     */
    public val dataSourceFieldName: kotlin.String = requireNotNull(builder.dataSourceFieldName) { "A non-null value must be provided for dataSourceFieldName" }
    /**
     * The format for date fields in the data source. If the field specified in `DataSourceFieldName` is a date field, you must specify the date format. If the field is not a date field, an exception is thrown.
     */
    public val dateFieldFormat: kotlin.String? = builder.dateFieldFormat
    /**
     * The name of the index field to map to the data source field. The index field type must match the data source field type.
     */
    public val indexFieldName: kotlin.String = requireNotNull(builder.indexFieldName) { "A non-null value must be provided for indexFieldName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceToIndexFieldMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceToIndexFieldMapping(")
        append("dataSourceFieldName=$dataSourceFieldName,")
        append("dateFieldFormat=$dateFieldFormat,")
        append("indexFieldName=$indexFieldName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceFieldName.hashCode()
        result = 31 * result + (dateFieldFormat?.hashCode() ?: 0)
        result = 31 * result + (indexFieldName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceToIndexFieldMapping

        if (dataSourceFieldName != other.dataSourceFieldName) return false
        if (dateFieldFormat != other.dateFieldFormat) return false
        if (indexFieldName != other.indexFieldName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceToIndexFieldMapping = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the field in the data source. You must first create the index field using the `UpdateIndex` API.
         */
        public var dataSourceFieldName: kotlin.String? = null
        /**
         * The format for date fields in the data source. If the field specified in `DataSourceFieldName` is a date field, you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        public var dateFieldFormat: kotlin.String? = null
        /**
         * The name of the index field to map to the data source field. The index field type must match the data source field type.
         */
        public var indexFieldName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceToIndexFieldMapping) : this() {
            this.dataSourceFieldName = x.dataSourceFieldName
            this.dateFieldFormat = x.dateFieldFormat
            this.indexFieldName = x.indexFieldName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceToIndexFieldMapping = DataSourceToIndexFieldMapping(this)

        internal fun correctErrors(): Builder {
            if (dataSourceFieldName == null) dataSourceFieldName = ""
            if (indexFieldName == null) indexFieldName = ""
            return this
        }
    }
}
