// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Maps a particular data source sync job to a particular data source.
 */
public class DataSourceSyncJobMetricTarget private constructor(builder: Builder) {
    /**
     * The ID of the data source that is running the sync job.
     */
    public val dataSourceId: kotlin.String = requireNotNull(builder.dataSourceId) { "A non-null value must be provided for dataSourceId" }
    /**
     * The ID of the sync job that is running on the data source.
     *
     * If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used and metrics are generated for this sync job.
     *
     * If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and documents are indexed/deleted at the index level without sync job metrics included.
     */
    public val dataSourceSyncJobId: kotlin.String? = builder.dataSourceSyncJobId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetricTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceSyncJobMetricTarget(")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceSyncJobId=$dataSourceSyncJobId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId.hashCode()
        result = 31 * result + (dataSourceSyncJobId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceSyncJobMetricTarget

        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceSyncJobId != other.dataSourceSyncJobId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetricTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the data source that is running the sync job.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The ID of the sync job that is running on the data source.
         *
         * If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used and metrics are generated for this sync job.
         *
         * If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and documents are indexed/deleted at the index level without sync job metrics included.
         */
        public var dataSourceSyncJobId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetricTarget) : this() {
            this.dataSourceId = x.dataSourceId
            this.dataSourceSyncJobId = x.dataSourceSyncJobId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetricTarget = DataSourceSyncJobMetricTarget(this)

        internal fun correctErrors(): Builder {
            if (dataSourceId == null) dataSourceId = ""
            return this
        }
    }
}
