// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a data source synchronization job.
 */
public class DataSourceSyncJob private constructor(builder: Builder) {
    /**
     * If the reason that the synchronization failed is due to an error with the underlying data source, this field contains a code that identifies the error.
     */
    public val dataSourceErrorCode: kotlin.String? = builder.dataSourceErrorCode
    /**
     * The Unix timestamp when the synchronization job completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * If the `Status` field is set to `FAILED`, the `ErrorCode` field indicates the reason the synchronization failed.
     */
    public val errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = builder.errorCode
    /**
     * If the `Status` field is set to `ERROR`, the `ErrorMessage` field contains a description of the error that caused the synchronization to fail.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * A identifier for the synchronization job.
     */
    public val executionId: kotlin.String? = builder.executionId
    /**
     * Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.
     */
    public val metrics: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetrics? = builder.metrics
    /**
     * The Unix timestamp when the synchronization job started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The execution status of the synchronization job. When the `Status` field is set to `SUCCEEDED`, the synchronization job is done. If the status code is set to `FAILED`, the `ErrorCode` and `ErrorMessage` fields give you the reason for the failure.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceSyncJob(")
        append("dataSourceErrorCode=$dataSourceErrorCode,")
        append("endTime=$endTime,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("executionId=$executionId,")
        append("metrics=$metrics,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceErrorCode?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (executionId?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceSyncJob

        if (dataSourceErrorCode != other.dataSourceErrorCode) return false
        if (endTime != other.endTime) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (executionId != other.executionId) return false
        if (metrics != other.metrics) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the reason that the synchronization failed is due to an error with the underlying data source, this field contains a code that identifies the error.
         */
        public var dataSourceErrorCode: kotlin.String? = null
        /**
         * The Unix timestamp when the synchronization job completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the `Status` field is set to `FAILED`, the `ErrorCode` field indicates the reason the synchronization failed.
         */
        public var errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = null
        /**
         * If the `Status` field is set to `ERROR`, the `ErrorMessage` field contains a description of the error that caused the synchronization to fail.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * A identifier for the synchronization job.
         */
        public var executionId: kotlin.String? = null
        /**
         * Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.
         */
        public var metrics: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetrics? = null
        /**
         * The Unix timestamp when the synchronization job started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The execution status of the synchronization job. When the `Status` field is set to `SUCCEEDED`, the synchronization job is done. If the status code is set to `FAILED`, the `ErrorCode` and `ErrorMessage` fields give you the reason for the failure.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJob) : this() {
            this.dataSourceErrorCode = x.dataSourceErrorCode
            this.endTime = x.endTime
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.executionId = x.executionId
            this.metrics = x.metrics
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceSyncJob = DataSourceSyncJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.kendra.model.DataSourceSyncJobMetrics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
