// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information for an Amazon Kendra data source.
 */
public class DataSourceConfiguration private constructor(builder: Builder) {
    /**
     * Provides the configuration information to connect to Alfresco as your data source.
     *
     * Support for `AlfrescoConfiguration` ended May 2023. We recommend migrating to or using the Alfresco data source template schema / [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) API.
     */
    @Deprecated("Deprecated AlfrescoConfiguration in favor of TemplateConfiguration")
    public val alfrescoConfiguration: aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration? = builder.alfrescoConfiguration
    /**
     * Provides the configuration information to connect to Box as your data source.
     */
    public val boxConfiguration: aws.sdk.kotlin.services.kendra.model.BoxConfiguration? = builder.boxConfiguration
    /**
     * Provides the configuration information to connect to Confluence as your data source.
     */
    public val confluenceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration? = builder.confluenceConfiguration
    /**
     * Provides the configuration information to connect to a database as your data source.
     */
    public val databaseConfiguration: aws.sdk.kotlin.services.kendra.model.DatabaseConfiguration? = builder.databaseConfiguration
    /**
     * Provides the configuration information to connect to Amazon FSx as your data source.
     *
     * Amazon Kendra now supports an upgraded Amazon FSx Windows connector.
     *
     * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `FsxConfiguration` object to configure your connector.
     *
     * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
     *
     * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
     */
    public val fsxConfiguration: aws.sdk.kotlin.services.kendra.model.FsxConfiguration? = builder.fsxConfiguration
    /**
     * Provides the configuration information to connect to GitHub as your data source.
     *
     * Amazon Kendra now supports an upgraded GitHub connector.
     *
     * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `GitHubConfiguration` object to configure your connector.
     *
     * Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
     *
     * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
     */
    public val gitHubConfiguration: aws.sdk.kotlin.services.kendra.model.GitHubConfiguration? = builder.gitHubConfiguration
    /**
     * Provides the configuration information to connect to Google Drive as your data source.
     */
    public val googleDriveConfiguration: aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration? = builder.googleDriveConfiguration
    /**
     * Provides the configuration information to connect to Jira as your data source.
     */
    public val jiraConfiguration: aws.sdk.kotlin.services.kendra.model.JiraConfiguration? = builder.jiraConfiguration
    /**
     * Provides the configuration information to connect to Microsoft OneDrive as your data source.
     */
    public val oneDriveConfiguration: aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration? = builder.oneDriveConfiguration
    /**
     * Provides the configuration information to connect to Quip as your data source.
     */
    public val quipConfiguration: aws.sdk.kotlin.services.kendra.model.QuipConfiguration? = builder.quipConfiguration
    /**
     * Provides the configuration information to connect to an Amazon S3 bucket as your data source.
     *
     * Amazon Kendra now supports an upgraded Amazon S3 connector.
     *
     * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `S3DataSourceConfiguration` object to configure your connector.
     *
     * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
     *
     * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
     */
    public val s3Configuration: aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration? = builder.s3Configuration
    /**
     * Provides the configuration information to connect to Salesforce as your data source.
     */
    public val salesforceConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration? = builder.salesforceConfiguration
    /**
     * Provides the configuration information to connect to ServiceNow as your data source.
     */
    public val serviceNowConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration? = builder.serviceNowConfiguration
    /**
     * Provides the configuration information to connect to Microsoft SharePoint as your data source.
     */
    public val sharePointConfiguration: aws.sdk.kotlin.services.kendra.model.SharePointConfiguration? = builder.sharePointConfiguration
    /**
     * Provides the configuration information to connect to Slack as your data source.
     *
     * Amazon Kendra now supports an upgraded Slack connector.
     *
     * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `SlackConfiguration` object to configure your connector.
     *
     * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
     *
     * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
     */
    public val slackConfiguration: aws.sdk.kotlin.services.kendra.model.SlackConfiguration? = builder.slackConfiguration
    /**
     * Provides a template for the configuration information to connect to your data source.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.kendra.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * Provides the configuration information required for Amazon Kendra Web Crawler.
     */
    public val webCrawlerConfiguration: aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration? = builder.webCrawlerConfiguration
    /**
     * Provides the configuration information to connect to Amazon WorkDocs as your data source.
     */
    public val workDocsConfiguration: aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration? = builder.workDocsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceConfiguration(")
        append("alfrescoConfiguration=$alfrescoConfiguration,")
        append("boxConfiguration=$boxConfiguration,")
        append("confluenceConfiguration=$confluenceConfiguration,")
        append("databaseConfiguration=$databaseConfiguration,")
        append("fsxConfiguration=$fsxConfiguration,")
        append("gitHubConfiguration=$gitHubConfiguration,")
        append("googleDriveConfiguration=$googleDriveConfiguration,")
        append("jiraConfiguration=$jiraConfiguration,")
        append("oneDriveConfiguration=$oneDriveConfiguration,")
        append("quipConfiguration=$quipConfiguration,")
        append("s3Configuration=$s3Configuration,")
        append("salesforceConfiguration=$salesforceConfiguration,")
        append("serviceNowConfiguration=$serviceNowConfiguration,")
        append("sharePointConfiguration=$sharePointConfiguration,")
        append("slackConfiguration=$slackConfiguration,")
        append("templateConfiguration=$templateConfiguration,")
        append("webCrawlerConfiguration=$webCrawlerConfiguration,")
        append("workDocsConfiguration=$workDocsConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alfrescoConfiguration?.hashCode() ?: 0
        result = 31 * result + (boxConfiguration?.hashCode() ?: 0)
        result = 31 * result + (confluenceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (databaseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fsxConfiguration?.hashCode() ?: 0)
        result = 31 * result + (gitHubConfiguration?.hashCode() ?: 0)
        result = 31 * result + (googleDriveConfiguration?.hashCode() ?: 0)
        result = 31 * result + (jiraConfiguration?.hashCode() ?: 0)
        result = 31 * result + (oneDriveConfiguration?.hashCode() ?: 0)
        result = 31 * result + (quipConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (salesforceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceNowConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sharePointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (slackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (webCrawlerConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workDocsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceConfiguration

        if (alfrescoConfiguration != other.alfrescoConfiguration) return false
        if (boxConfiguration != other.boxConfiguration) return false
        if (confluenceConfiguration != other.confluenceConfiguration) return false
        if (databaseConfiguration != other.databaseConfiguration) return false
        if (fsxConfiguration != other.fsxConfiguration) return false
        if (gitHubConfiguration != other.gitHubConfiguration) return false
        if (googleDriveConfiguration != other.googleDriveConfiguration) return false
        if (jiraConfiguration != other.jiraConfiguration) return false
        if (oneDriveConfiguration != other.oneDriveConfiguration) return false
        if (quipConfiguration != other.quipConfiguration) return false
        if (s3Configuration != other.s3Configuration) return false
        if (salesforceConfiguration != other.salesforceConfiguration) return false
        if (serviceNowConfiguration != other.serviceNowConfiguration) return false
        if (sharePointConfiguration != other.sharePointConfiguration) return false
        if (slackConfiguration != other.slackConfiguration) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (webCrawlerConfiguration != other.webCrawlerConfiguration) return false
        if (workDocsConfiguration != other.workDocsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides the configuration information to connect to Alfresco as your data source.
         *
         * Support for `AlfrescoConfiguration` ended May 2023. We recommend migrating to or using the Alfresco data source template schema / [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) API.
         */
        @Deprecated("Deprecated AlfrescoConfiguration in favor of TemplateConfiguration")
        public var alfrescoConfiguration: aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration? = null
        /**
         * Provides the configuration information to connect to Box as your data source.
         */
        public var boxConfiguration: aws.sdk.kotlin.services.kendra.model.BoxConfiguration? = null
        /**
         * Provides the configuration information to connect to Confluence as your data source.
         */
        public var confluenceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration? = null
        /**
         * Provides the configuration information to connect to a database as your data source.
         */
        public var databaseConfiguration: aws.sdk.kotlin.services.kendra.model.DatabaseConfiguration? = null
        /**
         * Provides the configuration information to connect to Amazon FSx as your data source.
         *
         * Amazon Kendra now supports an upgraded Amazon FSx Windows connector.
         *
         * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `FsxConfiguration` object to configure your connector.
         *
         * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
         *
         * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
         */
        public var fsxConfiguration: aws.sdk.kotlin.services.kendra.model.FsxConfiguration? = null
        /**
         * Provides the configuration information to connect to GitHub as your data source.
         *
         * Amazon Kendra now supports an upgraded GitHub connector.
         *
         * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `GitHubConfiguration` object to configure your connector.
         *
         * Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
         *
         * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
         */
        public var gitHubConfiguration: aws.sdk.kotlin.services.kendra.model.GitHubConfiguration? = null
        /**
         * Provides the configuration information to connect to Google Drive as your data source.
         */
        public var googleDriveConfiguration: aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration? = null
        /**
         * Provides the configuration information to connect to Jira as your data source.
         */
        public var jiraConfiguration: aws.sdk.kotlin.services.kendra.model.JiraConfiguration? = null
        /**
         * Provides the configuration information to connect to Microsoft OneDrive as your data source.
         */
        public var oneDriveConfiguration: aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration? = null
        /**
         * Provides the configuration information to connect to Quip as your data source.
         */
        public var quipConfiguration: aws.sdk.kotlin.services.kendra.model.QuipConfiguration? = null
        /**
         * Provides the configuration information to connect to an Amazon S3 bucket as your data source.
         *
         * Amazon Kendra now supports an upgraded Amazon S3 connector.
         *
         * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `S3DataSourceConfiguration` object to configure your connector.
         *
         * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
         *
         * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
         */
        public var s3Configuration: aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration? = null
        /**
         * Provides the configuration information to connect to Salesforce as your data source.
         */
        public var salesforceConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration? = null
        /**
         * Provides the configuration information to connect to ServiceNow as your data source.
         */
        public var serviceNowConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration? = null
        /**
         * Provides the configuration information to connect to Microsoft SharePoint as your data source.
         */
        public var sharePointConfiguration: aws.sdk.kotlin.services.kendra.model.SharePointConfiguration? = null
        /**
         * Provides the configuration information to connect to Slack as your data source.
         *
         * Amazon Kendra now supports an upgraded Slack connector.
         *
         * You must now use the [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) object instead of the `SlackConfiguration` object to configure your connector.
         *
         * Connectors configured using the older console and API architecture will continue to function as configured. However, you won't be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.
         *
         * We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.
         */
        public var slackConfiguration: aws.sdk.kotlin.services.kendra.model.SlackConfiguration? = null
        /**
         * Provides a template for the configuration information to connect to your data source.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.kendra.model.TemplateConfiguration? = null
        /**
         * Provides the configuration information required for Amazon Kendra Web Crawler.
         */
        public var webCrawlerConfiguration: aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration? = null
        /**
         * Provides the configuration information to connect to Amazon WorkDocs as your data source.
         */
        public var workDocsConfiguration: aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration) : this() {
            this.alfrescoConfiguration = x.alfrescoConfiguration
            this.boxConfiguration = x.boxConfiguration
            this.confluenceConfiguration = x.confluenceConfiguration
            this.databaseConfiguration = x.databaseConfiguration
            this.fsxConfiguration = x.fsxConfiguration
            this.gitHubConfiguration = x.gitHubConfiguration
            this.googleDriveConfiguration = x.googleDriveConfiguration
            this.jiraConfiguration = x.jiraConfiguration
            this.oneDriveConfiguration = x.oneDriveConfiguration
            this.quipConfiguration = x.quipConfiguration
            this.s3Configuration = x.s3Configuration
            this.salesforceConfiguration = x.salesforceConfiguration
            this.serviceNowConfiguration = x.serviceNowConfiguration
            this.sharePointConfiguration = x.sharePointConfiguration
            this.slackConfiguration = x.slackConfiguration
            this.templateConfiguration = x.templateConfiguration
            this.webCrawlerConfiguration = x.webCrawlerConfiguration
            this.workDocsConfiguration = x.workDocsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration = DataSourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration] inside the given [block]
         */
        @Deprecated("Deprecated AlfrescoConfiguration in favor of TemplateConfiguration")
        public fun alfrescoConfiguration(block: aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration.Builder.() -> kotlin.Unit) {
            this.alfrescoConfiguration = aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.BoxConfiguration] inside the given [block]
         */
        public fun boxConfiguration(block: aws.sdk.kotlin.services.kendra.model.BoxConfiguration.Builder.() -> kotlin.Unit) {
            this.boxConfiguration = aws.sdk.kotlin.services.kendra.model.BoxConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration] inside the given [block]
         */
        public fun confluenceConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration.Builder.() -> kotlin.Unit) {
            this.confluenceConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DatabaseConfiguration] inside the given [block]
         */
        public fun databaseConfiguration(block: aws.sdk.kotlin.services.kendra.model.DatabaseConfiguration.Builder.() -> kotlin.Unit) {
            this.databaseConfiguration = aws.sdk.kotlin.services.kendra.model.DatabaseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.FsxConfiguration] inside the given [block]
         */
        public fun fsxConfiguration(block: aws.sdk.kotlin.services.kendra.model.FsxConfiguration.Builder.() -> kotlin.Unit) {
            this.fsxConfiguration = aws.sdk.kotlin.services.kendra.model.FsxConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.GitHubConfiguration] inside the given [block]
         */
        public fun gitHubConfiguration(block: aws.sdk.kotlin.services.kendra.model.GitHubConfiguration.Builder.() -> kotlin.Unit) {
            this.gitHubConfiguration = aws.sdk.kotlin.services.kendra.model.GitHubConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration] inside the given [block]
         */
        public fun googleDriveConfiguration(block: aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration.Builder.() -> kotlin.Unit) {
            this.googleDriveConfiguration = aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.JiraConfiguration] inside the given [block]
         */
        public fun jiraConfiguration(block: aws.sdk.kotlin.services.kendra.model.JiraConfiguration.Builder.() -> kotlin.Unit) {
            this.jiraConfiguration = aws.sdk.kotlin.services.kendra.model.JiraConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration] inside the given [block]
         */
        public fun oneDriveConfiguration(block: aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration.Builder.() -> kotlin.Unit) {
            this.oneDriveConfiguration = aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.QuipConfiguration] inside the given [block]
         */
        public fun quipConfiguration(block: aws.sdk.kotlin.services.kendra.model.QuipConfiguration.Builder.() -> kotlin.Unit) {
            this.quipConfiguration = aws.sdk.kotlin.services.kendra.model.QuipConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration] inside the given [block]
         */
        public fun salesforceConfiguration(block: aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration.Builder.() -> kotlin.Unit) {
            this.salesforceConfiguration = aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration] inside the given [block]
         */
        public fun serviceNowConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceNowConfiguration = aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SharePointConfiguration] inside the given [block]
         */
        public fun sharePointConfiguration(block: aws.sdk.kotlin.services.kendra.model.SharePointConfiguration.Builder.() -> kotlin.Unit) {
            this.sharePointConfiguration = aws.sdk.kotlin.services.kendra.model.SharePointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SlackConfiguration] inside the given [block]
         */
        public fun slackConfiguration(block: aws.sdk.kotlin.services.kendra.model.SlackConfiguration.Builder.() -> kotlin.Unit) {
            this.slackConfiguration = aws.sdk.kotlin.services.kendra.model.SlackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.kendra.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.kendra.model.TemplateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration] inside the given [block]
         */
        public fun webCrawlerConfiguration(block: aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration.Builder.() -> kotlin.Unit) {
            this.webCrawlerConfiguration = aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration] inside the given [block]
         */
        public fun workDocsConfiguration(block: aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration.Builder.() -> kotlin.Unit) {
            this.workDocsConfiguration = aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
