// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateQuerySuggestionsBlockListRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a query suggestions block list.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the block list.
     *
     * For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the index you want to create a query suggestions block list for.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * A name for the block list.
     *
     * For example, the name 'offensive-words', which includes all offensive words that could appear in user queries and need to be blocked from suggestions.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket that contains the block list text file. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The S3 path to your block list text file in your S3 bucket.
     *
     * Each block word or phrase should be on a separate line in a text file.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     */
    public val sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sourceS3Path
    /**
     * A list of key-value pairs that identify or categorize the block list. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQuerySuggestionsBlockListRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sourceS3Path=$sourceS3Path,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Path?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQuerySuggestionsBlockListRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sourceS3Path != other.sourceS3Path) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A token that you provide to identify the request to create a query suggestions block list.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the block list.
         *
         * For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the index you want to create a query suggestions block list for.
         */
        public var indexId: kotlin.String? = null
        /**
         * A name for the block list.
         *
         * For example, the name 'offensive-words', which includes all offensive words that could appear in user queries and need to be blocked from suggestions.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket that contains the block list text file. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The S3 path to your block list text file in your S3 bucket.
         *
         * Each block word or phrase should be on a separate line in a text file.
         *
         * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
         */
        public var sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * A list of key-value pairs that identify or categorize the block list. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.indexId = x.indexId
            this.name = x.name
            this.roleArn = x.roleArn
            this.sourceS3Path = x.sourceS3Path
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = CreateQuerySuggestionsBlockListRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun sourceS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sourceS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
