// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIndexRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the index.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for production. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed.
     *
     * The `Edition` parameter is optional. If you don't supply a value, the default is `ENTERPRISE_EDITION`.
     *
     * For more information on quota limits for Gen AI Enterprise Edition, Enterprise Edition, and Developer Edition indices, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     */
    public val edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = builder.edition
    /**
     * A name for the index.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access your Amazon CloudWatch logs and metrics. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The identifier of the KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user context policy.
     *
     * If you're using an Amazon Kendra Gen AI Enterprise Edition index, you can only use `ATTRIBUTE_FILTER` to filter search results by user context. If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to use `USER_TOKEN` to configure user context policy, Amazon Kendra returns a `ValidationException` error.
     *
     * ## ATTRIBUTE_FILTER
     * All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of `_user_id` and `_group_ids` or you can provide user and group information in `UserContext`.
     *
     * ## USER_TOKEN
     * Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.
     */
    public val userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = builder.userContextPolicy
    /**
     * Gets users and groups from IAM Identity Center identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     *
     * If you're using an Amazon Kendra Gen AI Enterprise Edition index, `UserGroupResolutionConfiguration` isn't supported.
     */
    public val userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = builder.userGroupResolutionConfiguration
    /**
     * The user token configuration.
     *
     * If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to use `UserTokenConfigurations` to configure user context policy, Amazon Kendra returns a `ValidationException` error.
     */
    public val userTokenConfigurations: List<UserTokenConfiguration>? = builder.userTokenConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIndexRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("edition=$edition,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("tags=$tags,")
        append("userContextPolicy=$userContextPolicy,")
        append("userGroupResolutionConfiguration=$userGroupResolutionConfiguration,")
        append("userTokenConfigurations=$userTokenConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userContextPolicy?.hashCode() ?: 0)
        result = 31 * result + (userGroupResolutionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userTokenConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIndexRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (edition != other.edition) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (tags != other.tags) return false
        if (userContextPolicy != other.userContextPolicy) return false
        if (userGroupResolutionConfiguration != other.userGroupResolutionConfiguration) return false
        if (userTokenConfigurations != other.userTokenConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the index.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for production. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed.
         *
         * The `Edition` parameter is optional. If you don't supply a value, the default is `ENTERPRISE_EDITION`.
         *
         * For more information on quota limits for Gen AI Enterprise Edition, Enterprise Edition, and Developer Edition indices, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
         */
        public var edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = null
        /**
         * A name for the index.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access your Amazon CloudWatch logs and metrics. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The identifier of the KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = null
        /**
         * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null
        /**
         * The user context policy.
         *
         * If you're using an Amazon Kendra Gen AI Enterprise Edition index, you can only use `ATTRIBUTE_FILTER` to filter search results by user context. If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to use `USER_TOKEN` to configure user context policy, Amazon Kendra returns a `ValidationException` error.
         *
         * ## ATTRIBUTE_FILTER
         * All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of `_user_id` and `_group_ids` or you can provide user and group information in `UserContext`.
         *
         * ## USER_TOKEN
         * Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.
         */
        public var userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = null
        /**
         * Gets users and groups from IAM Identity Center identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
         *
         * If you're using an Amazon Kendra Gen AI Enterprise Edition index, `UserGroupResolutionConfiguration` isn't supported.
         */
        public var userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = null
        /**
         * The user token configuration.
         *
         * If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to use `UserTokenConfigurations` to configure user context policy, Amazon Kendra returns a `ValidationException` error.
         */
        public var userTokenConfigurations: List<UserTokenConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateIndexRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.edition = x.edition
            this.name = x.name
            this.roleArn = x.roleArn
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.tags = x.tags
            this.userContextPolicy = x.userContextPolicy
            this.userGroupResolutionConfiguration = x.userGroupResolutionConfiguration
            this.userTokenConfigurations = x.userTokenConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = CreateIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration] inside the given [block]
         */
        public fun userGroupResolutionConfiguration(block: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.Builder.() -> kotlin.Unit) {
            this.userGroupResolutionConfiguration = aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
