// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFeaturedResultsSetRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a set of featured results. Multiple calls to the `CreateFeaturedResultsSet` API with the same client token will create only one featured results set.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the set of featured results.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of document IDs for the documents you want to feature at the top of the search results page. For more information on the list of documents, see [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html).
     */
    public val featuredDocuments: List<FeaturedDocument>? = builder.featuredDocuments
    /**
     * A name for the set of featured results.
     */
    public val featuredResultsSetName: kotlin.String? = builder.featuredResultsSetName
    /**
     * The identifier of the index that you want to use for featuring results.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * A list of queries for featuring results. For more information on the list of queries, see [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html).
     */
    public val queryTexts: List<String>? = builder.queryTexts
    /**
     * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = builder.status
    /**
     * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols:_ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFeaturedResultsSetRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("featuredDocuments=$featuredDocuments,")
        append("featuredResultsSetName=$featuredResultsSetName,")
        append("indexId=$indexId,")
        append("queryTexts=$queryTexts,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (featuredDocuments?.hashCode() ?: 0)
        result = 31 * result + (featuredResultsSetName?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (queryTexts?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFeaturedResultsSetRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (featuredDocuments != other.featuredDocuments) return false
        if (featuredResultsSetName != other.featuredResultsSetName) return false
        if (indexId != other.indexId) return false
        if (queryTexts != other.queryTexts) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A token that you provide to identify the request to create a set of featured results. Multiple calls to the `CreateFeaturedResultsSet` API with the same client token will create only one featured results set.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the set of featured results.
         */
        public var description: kotlin.String? = null
        /**
         * A list of document IDs for the documents you want to feature at the top of the search results page. For more information on the list of documents, see [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html).
         */
        public var featuredDocuments: List<FeaturedDocument>? = null
        /**
         * A name for the set of featured results.
         */
        public var featuredResultsSetName: kotlin.String? = null
        /**
         * The identifier of the index that you want to use for featuring results.
         */
        public var indexId: kotlin.String? = null
        /**
         * A list of queries for featuring results. For more information on the list of queries, see [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html).
         */
        public var queryTexts: List<String>? = null
        /**
         * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = null
        /**
         * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols:_ . : / = + - @.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.featuredDocuments = x.featuredDocuments
            this.featuredResultsSetName = x.featuredResultsSetName
            this.indexId = x.indexId
            this.queryTexts = x.queryTexts
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetRequest = CreateFeaturedResultsSetRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
