// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFaqRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a FAQ. Multiple calls to the `CreateFaqRequest` API with the same client token will create only one FAQ.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the FAQ.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.
     *
     * The default format is CSV.
     *
     * The format must match the format of the file stored in the S3 bucket identified in the `S3Path` parameter.
     *
     * For more information, see [Adding questions and answers](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
     */
    public val fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = builder.fileFormat
    /**
     * The identifier of the index for the FAQ.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    public val languageCode: kotlin.String? = builder.languageCode
    /**
     * A name for the FAQ.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the FAQ file. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The path to the FAQ file in S3.
     */
    public val s3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.s3Path
    /**
     * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateFaqRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFaqRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("fileFormat=$fileFormat,")
        append("indexId=$indexId,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("s3Path=$s3Path,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fileFormat?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFaqRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (fileFormat != other.fileFormat) return false
        if (indexId != other.indexId) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (s3Path != other.s3Path) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateFaqRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A token that you provide to identify the request to create a FAQ. Multiple calls to the `CreateFaqRequest` API with the same client token will create only one FAQ.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the FAQ.
         */
        public var description: kotlin.String? = null
        /**
         * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.
         *
         * The default format is CSV.
         *
         * The format must match the format of the file stored in the S3 bucket identified in the `S3Path` parameter.
         *
         * For more information, see [Adding questions and answers](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
         */
        public var fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = null
        /**
         * The identifier of the index for the FAQ.
         */
        public var indexId: kotlin.String? = null
        /**
         * The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
         */
        public var languageCode: kotlin.String? = null
        /**
         * A name for the FAQ.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the FAQ file. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The path to the FAQ file in S3.
         */
        public var s3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateFaqRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.fileFormat = x.fileFormat
            this.indexId = x.indexId
            this.languageCode = x.languageCode
            this.name = x.name
            this.roleArn = x.roleArn
            this.s3Path = x.s3Path
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateFaqRequest = CreateFaqRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun s3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.s3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
