// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to Confluence as your data source.
 */
public class ConfluenceConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information for indexing attachments to Confluence blogs and pages.
     */
    public val attachmentConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration? = builder.attachmentConfiguration
    /**
     * Whether you want to connect to Confluence using basic authentication of user name and password, or a personal access token. You can use a personal access token for Confluence Server.
     */
    public val authenticationType: aws.sdk.kotlin.services.kendra.model.ConfluenceAuthenticationType? = builder.authenticationType
    /**
     * Configuration information for indexing Confluence blogs.
     */
    public val blogConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration? = builder.blogConfiguration
    /**
     * A list of regular expression patterns to exclude certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are excluded from the index. Content that doesn't match the patterns is included in the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of regular expression patterns to include certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are included in the index. Content that doesn't match the patterns is excluded from the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * Configuration information for indexing Confluence pages.
     */
    public val pageConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration? = builder.pageConfiguration
    /**
     * Configuration information to connect to your Confluence URL instance via a web proxy. You can use this option for Confluence Server.
     *
     * You must provide the website host name and port number. For example, the host name of *https://a.example.com/page1.html* is "a.example.com" and the port is 443, the standard port for HTTPS.
     *
     * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.
     *
     * It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the Confluence instance. If you use Confluence Cloud, you use a generated API token as the password.
     *
     * You can also provide authentication credentials in the form of a personal access token. For more information, see [Using a Confluence data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-confluence.html).
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The URL of your Confluence instance. Use the full URL of the server. For example, *https://server.example.com:port&#47;*. You can also use an IP address, for example, *https://192.168.1.113&#47;*.
     */
    public val serverUrl: kotlin.String = requireNotNull(builder.serverUrl) { "A non-null value must be provided for serverUrl" }
    /**
     * Configuration information for indexing Confluence spaces.
     */
    public val spaceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration? = builder.spaceConfiguration
    /**
     * The version or the type of Confluence installation to connect to.
     */
    public val version: aws.sdk.kotlin.services.kendra.model.ConfluenceVersion = requireNotNull(builder.version) { "A non-null value must be provided for version" }
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceConfiguration(")
        append("attachmentConfiguration=$attachmentConfiguration,")
        append("authenticationType=$authenticationType,")
        append("blogConfiguration=$blogConfiguration,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("pageConfiguration=$pageConfiguration,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("secretArn=$secretArn,")
        append("serverUrl=$serverUrl,")
        append("spaceConfiguration=$spaceConfiguration,")
        append("version=$version,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentConfiguration?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (blogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (pageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (serverUrl.hashCode())
        result = 31 * result + (spaceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceConfiguration

        if (attachmentConfiguration != other.attachmentConfiguration) return false
        if (authenticationType != other.authenticationType) return false
        if (blogConfiguration != other.blogConfiguration) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (pageConfiguration != other.pageConfiguration) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (serverUrl != other.serverUrl) return false
        if (spaceConfiguration != other.spaceConfiguration) return false
        if (version != other.version) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration information for indexing attachments to Confluence blogs and pages.
         */
        public var attachmentConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration? = null
        /**
         * Whether you want to connect to Confluence using basic authentication of user name and password, or a personal access token. You can use a personal access token for Confluence Server.
         */
        public var authenticationType: aws.sdk.kotlin.services.kendra.model.ConfluenceAuthenticationType? = null
        /**
         * Configuration information for indexing Confluence blogs.
         */
        public var blogConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration? = null
        /**
         * A list of regular expression patterns to exclude certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are excluded from the index. Content that doesn't match the patterns is included in the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are included in the index. Content that doesn't match the patterns is excluded from the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * Configuration information for indexing Confluence pages.
         */
        public var pageConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration? = null
        /**
         * Configuration information to connect to your Confluence URL instance via a web proxy. You can use this option for Confluence Server.
         *
         * You must provide the website host name and port number. For example, the host name of *https://a.example.com/page1.html* is "a.example.com" and the port is 443, the standard port for HTTPS.
         *
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.
         *
         * It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the Confluence instance. If you use Confluence Cloud, you use a generated API token as the password.
         *
         * You can also provide authentication credentials in the form of a personal access token. For more information, see [Using a Confluence data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-confluence.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * The URL of your Confluence instance. Use the full URL of the server. For example, *https://server.example.com:port&#47;*. You can also use an IP address, for example, *https://192.168.1.113&#47;*.
         */
        public var serverUrl: kotlin.String? = null
        /**
         * Configuration information for indexing Confluence spaces.
         */
        public var spaceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration? = null
        /**
         * The version or the type of Confluence installation to connect to.
         */
        public var version: aws.sdk.kotlin.services.kendra.model.ConfluenceVersion? = null
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration) : this() {
            this.attachmentConfiguration = x.attachmentConfiguration
            this.authenticationType = x.authenticationType
            this.blogConfiguration = x.blogConfiguration
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.pageConfiguration = x.pageConfiguration
            this.proxyConfiguration = x.proxyConfiguration
            this.secretArn = x.secretArn
            this.serverUrl = x.serverUrl
            this.spaceConfiguration = x.spaceConfiguration
            this.version = x.version
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = ConfluenceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration] inside the given [block]
         */
        public fun attachmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration.Builder.() -> kotlin.Unit) {
            this.attachmentConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration] inside the given [block]
         */
        public fun blogConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration.Builder.() -> kotlin.Unit) {
            this.blogConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration] inside the given [block]
         */
        public fun pageConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration.Builder.() -> kotlin.Unit) {
            this.pageConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ProxyConfiguration] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration] inside the given [block]
         */
        public fun spaceConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration.Builder.() -> kotlin.Unit) {
            this.spaceConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (secretArn == null) secretArn = ""
            if (serverUrl == null) serverUrl = ""
            if (version == null) version = ConfluenceVersion.SdkUnknown("no value provided")
            return this
        }
    }
}
