// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Maps attributes or field names of Confluence attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Confluence fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Confuence data source field names must exist in your Confluence custom metadata.
 */
public class ConfluenceAttachmentToIndexFieldMapping private constructor(builder: Builder) {
    /**
     * The name of the field in the data source.
     *
     * You must first create the index field using the `UpdateIndex` API.
     */
    public val dataSourceFieldName: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentFieldName? = builder.dataSourceFieldName
    /**
     * The format for date fields in the data source. If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
     */
    public val dateFieldFormat: kotlin.String? = builder.dateFieldFormat
    /**
     * The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.
     */
    public val indexFieldName: kotlin.String? = builder.indexFieldName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceAttachmentToIndexFieldMapping(")
        append("dataSourceFieldName=$dataSourceFieldName,")
        append("dateFieldFormat=$dateFieldFormat,")
        append("indexFieldName=$indexFieldName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceFieldName?.hashCode() ?: 0
        result = 31 * result + (dateFieldFormat?.hashCode() ?: 0)
        result = 31 * result + (indexFieldName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceAttachmentToIndexFieldMapping

        if (dataSourceFieldName != other.dataSourceFieldName) return false
        if (dateFieldFormat != other.dateFieldFormat) return false
        if (indexFieldName != other.indexFieldName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the field in the data source.
         *
         * You must first create the index field using the `UpdateIndex` API.
         */
        public var dataSourceFieldName: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentFieldName? = null
        /**
         * The format for date fields in the data source. If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        public var dateFieldFormat: kotlin.String? = null
        /**
         * The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.
         */
        public var indexFieldName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping) : this() {
            this.dataSourceFieldName = x.dataSourceFieldName
            this.dateFieldFormat = x.dateFieldFormat
            this.indexFieldName = x.indexFieldName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping = ConfluenceAttachmentToIndexFieldMapping(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
