// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration of attachment settings for the Confluence data source. Attachment settings are optional, if you don't specify settings attachments, Amazon Kendra won't index them.
 */
public class ConfluenceAttachmentConfiguration private constructor(builder: Builder) {
    /**
     * Maps attributes or field names of Confluence attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Confluence fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Confluence data source field names must exist in your Confluence custom metadata.
     *
     * If you specify the `AttachentFieldMappings` parameter, you must specify at least one field mapping.
     */
    public val attachmentFieldMappings: List<ConfluenceAttachmentToIndexFieldMapping>? = builder.attachmentFieldMappings
    /**
     * `TRUE` to index attachments of pages and blogs in Confluence.
     */
    public val crawlAttachments: kotlin.Boolean = builder.crawlAttachments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceAttachmentConfiguration(")
        append("attachmentFieldMappings=$attachmentFieldMappings,")
        append("crawlAttachments=$crawlAttachments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (crawlAttachments.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceAttachmentConfiguration

        if (attachmentFieldMappings != other.attachmentFieldMappings) return false
        if (crawlAttachments != other.crawlAttachments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Maps attributes or field names of Confluence attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Confluence fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Confluence data source field names must exist in your Confluence custom metadata.
         *
         * If you specify the `AttachentFieldMappings` parameter, you must specify at least one field mapping.
         */
        public var attachmentFieldMappings: List<ConfluenceAttachmentToIndexFieldMapping>? = null
        /**
         * `TRUE` to index attachments of pages and blogs in Confluence.
         */
        public var crawlAttachments: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration) : this() {
            this.attachmentFieldMappings = x.attachmentFieldMappings
            this.crawlAttachments = x.crawlAttachments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = ConfluenceAttachmentConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
