// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about how Amazon Kendra should use the columns of a database in an index.
 */
public class ColumnConfiguration private constructor(builder: Builder) {
    /**
     * One to five columns that indicate when a document in the database has changed.
     */
    public val changeDetectingColumns: List<String> = requireNotNull(builder.changeDetectingColumns) { "A non-null value must be provided for changeDetectingColumns" }
    /**
     * The column that contains the contents of the document.
     */
    public val documentDataColumnName: kotlin.String = requireNotNull(builder.documentDataColumnName) { "A non-null value must be provided for documentDataColumnName" }
    /**
     * The column that provides the document's identifier.
     */
    public val documentIdColumnName: kotlin.String = requireNotNull(builder.documentIdColumnName) { "A non-null value must be provided for documentIdColumnName" }
    /**
     * The column that contains the title of the document.
     */
    public val documentTitleColumnName: kotlin.String? = builder.documentTitleColumnName
    /**
     * An array of objects that map database column names to the corresponding fields in an index. You must first create the fields in the index using the `UpdateIndex` API.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ColumnConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ColumnConfiguration(")
        append("changeDetectingColumns=$changeDetectingColumns,")
        append("documentDataColumnName=$documentDataColumnName,")
        append("documentIdColumnName=$documentIdColumnName,")
        append("documentTitleColumnName=$documentTitleColumnName,")
        append("fieldMappings=$fieldMappings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeDetectingColumns.hashCode()
        result = 31 * result + (documentDataColumnName.hashCode())
        result = 31 * result + (documentIdColumnName.hashCode())
        result = 31 * result + (documentTitleColumnName?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ColumnConfiguration

        if (changeDetectingColumns != other.changeDetectingColumns) return false
        if (documentDataColumnName != other.documentDataColumnName) return false
        if (documentIdColumnName != other.documentIdColumnName) return false
        if (documentTitleColumnName != other.documentTitleColumnName) return false
        if (fieldMappings != other.fieldMappings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ColumnConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One to five columns that indicate when a document in the database has changed.
         */
        public var changeDetectingColumns: List<String>? = null
        /**
         * The column that contains the contents of the document.
         */
        public var documentDataColumnName: kotlin.String? = null
        /**
         * The column that provides the document's identifier.
         */
        public var documentIdColumnName: kotlin.String? = null
        /**
         * The column that contains the title of the document.
         */
        public var documentTitleColumnName: kotlin.String? = null
        /**
         * An array of objects that map database column names to the corresponding fields in an index. You must first create the fields in the index using the `UpdateIndex` API.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ColumnConfiguration) : this() {
            this.changeDetectingColumns = x.changeDetectingColumns
            this.documentDataColumnName = x.documentDataColumnName
            this.documentIdColumnName = x.documentIdColumnName
            this.documentTitleColumnName = x.documentTitleColumnName
            this.fieldMappings = x.fieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ColumnConfiguration = ColumnConfiguration(this)

        internal fun correctErrors(): Builder {
            if (changeDetectingColumns == null) changeDetectingColumns = emptyList()
            if (documentDataColumnName == null) documentDataColumnName = ""
            if (documentIdColumnName == null) documentIdColumnName = ""
            return this
        }
    }
}
