// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies how to group results by document attribute value, and how to display them collapsed/expanded under a designated primary document for each group.
 */
public class CollapseConfiguration private constructor(builder: Builder) {
    /**
     * The document attribute used to group search results. You can use any attribute that has the `Sortable` flag set to true. You can also sort by any of the following built-in attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".
     */
    public val documentAttributeKey: kotlin.String = requireNotNull(builder.documentAttributeKey) { "A non-null value must be provided for documentAttributeKey" }
    /**
     * Specifies whether to expand the collapsed results.
     */
    public val expand: kotlin.Boolean = builder.expand
    /**
     * Provides configuration information to customize expansion options for a collapsed group.
     */
    public val expandConfiguration: aws.sdk.kotlin.services.kendra.model.ExpandConfiguration? = builder.expandConfiguration
    /**
     * Specifies the behavior for documents without a value for the collapse attribute.
     *
     * Amazon Kendra offers three customization options:
     * + Choose to `COLLAPSE` all documents with null or missing values in one group. This is the default configuration.
     * + Choose to `IGNORE` documents with null or missing values. Ignored documents will not appear in query results.
     * + Choose to `EXPAND` each document with a null or missing value into a group of its own.
     */
    public val missingAttributeKeyStrategy: aws.sdk.kotlin.services.kendra.model.MissingAttributeKeyStrategy? = builder.missingAttributeKeyStrategy
    /**
     * A prioritized list of document attributes/fields that determine the primary document among those in a collapsed group.
     */
    public val sortingConfigurations: List<SortingConfiguration>? = builder.sortingConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CollapseConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollapseConfiguration(")
        append("documentAttributeKey=$documentAttributeKey,")
        append("expand=$expand,")
        append("expandConfiguration=$expandConfiguration,")
        append("missingAttributeKeyStrategy=$missingAttributeKeyStrategy,")
        append("sortingConfigurations=$sortingConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentAttributeKey.hashCode()
        result = 31 * result + (expand.hashCode())
        result = 31 * result + (expandConfiguration?.hashCode() ?: 0)
        result = 31 * result + (missingAttributeKeyStrategy?.hashCode() ?: 0)
        result = 31 * result + (sortingConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollapseConfiguration

        if (documentAttributeKey != other.documentAttributeKey) return false
        if (expand != other.expand) return false
        if (expandConfiguration != other.expandConfiguration) return false
        if (missingAttributeKeyStrategy != other.missingAttributeKeyStrategy) return false
        if (sortingConfigurations != other.sortingConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CollapseConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The document attribute used to group search results. You can use any attribute that has the `Sortable` flag set to true. You can also sort by any of the following built-in attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".
         */
        public var documentAttributeKey: kotlin.String? = null
        /**
         * Specifies whether to expand the collapsed results.
         */
        public var expand: kotlin.Boolean = false
        /**
         * Provides configuration information to customize expansion options for a collapsed group.
         */
        public var expandConfiguration: aws.sdk.kotlin.services.kendra.model.ExpandConfiguration? = null
        /**
         * Specifies the behavior for documents without a value for the collapse attribute.
         *
         * Amazon Kendra offers three customization options:
         * + Choose to `COLLAPSE` all documents with null or missing values in one group. This is the default configuration.
         * + Choose to `IGNORE` documents with null or missing values. Ignored documents will not appear in query results.
         * + Choose to `EXPAND` each document with a null or missing value into a group of its own.
         */
        public var missingAttributeKeyStrategy: aws.sdk.kotlin.services.kendra.model.MissingAttributeKeyStrategy? = null
        /**
         * A prioritized list of document attributes/fields that determine the primary document among those in a collapsed group.
         */
        public var sortingConfigurations: List<SortingConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CollapseConfiguration) : this() {
            this.documentAttributeKey = x.documentAttributeKey
            this.expand = x.expand
            this.expandConfiguration = x.expandConfiguration
            this.missingAttributeKeyStrategy = x.missingAttributeKeyStrategy
            this.sortingConfigurations = x.sortingConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CollapseConfiguration = CollapseConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ExpandConfiguration] inside the given [block]
         */
        public fun expandConfiguration(block: aws.sdk.kotlin.services.kendra.model.ExpandConfiguration.Builder.() -> kotlin.Unit) {
            this.expandConfiguration = aws.sdk.kotlin.services.kendra.model.ExpandConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (documentAttributeKey == null) documentAttributeKey = ""
            return this
        }
    }
}
