// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Gathers information about when a particular result was clicked by a user. Your application uses the `SubmitFeedback` API to provide click information.
 */
public class ClickFeedback private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the result was clicked.
     */
    public val clickTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.clickTime) { "A non-null value must be provided for clickTime" }
    /**
     * The identifier of the search result that was clicked.
     */
    public val resultId: kotlin.String = requireNotNull(builder.resultId) { "A non-null value must be provided for resultId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ClickFeedback = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClickFeedback(")
        append("clickTime=$clickTime,")
        append("resultId=$resultId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clickTime.hashCode()
        result = 31 * result + (resultId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClickFeedback

        if (clickTime != other.clickTime) return false
        if (resultId != other.resultId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ClickFeedback = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp when the result was clicked.
         */
        public var clickTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the search result that was clicked.
         */
        public var resultId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ClickFeedback) : this() {
            this.clickTime = x.clickTime
            this.resultId = x.resultId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ClickFeedback = ClickFeedback(this)

        internal fun correctErrors(): Builder {
            if (clickTime == null) clickTime = Instant.fromEpochSeconds(0)
            if (resultId == null) resultId = ""
            return this
        }
    }
}
