// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies additional capacity units configured for your Enterprise Edition index. You can add and remove capacity units to fit your usage requirements.
 */
public class CapacityUnitsConfiguration private constructor(builder: Builder) {
    /**
     * The amount of extra query capacity for an index and [GetQuerySuggestions](https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html) capacity.
     *
     * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day. You can add up to 100 extra capacity units.
     *
     * `GetQuerySuggestions` capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and `GetQuerySuggestions` capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the `GetQuerySuggestions` capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
     */
    public val queryCapacityUnits: kotlin.Int = requireNotNull(builder.queryCapacityUnits) { "A non-null value must be provided for queryCapacityUnits" }
    /**
     * The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. You can add up to 100 extra capacity units.
     */
    public val storageCapacityUnits: kotlin.Int = requireNotNull(builder.storageCapacityUnits) { "A non-null value must be provided for storageCapacityUnits" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityUnitsConfiguration(")
        append("queryCapacityUnits=$queryCapacityUnits,")
        append("storageCapacityUnits=$storageCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryCapacityUnits
        result = 31 * result + (storageCapacityUnits)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityUnitsConfiguration

        if (queryCapacityUnits != other.queryCapacityUnits) return false
        if (storageCapacityUnits != other.storageCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of extra query capacity for an index and [GetQuerySuggestions](https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html) capacity.
         *
         * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day. You can add up to 100 extra capacity units.
         *
         * `GetQuerySuggestions` capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and `GetQuerySuggestions` capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the `GetQuerySuggestions` capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
         */
        public var queryCapacityUnits: kotlin.Int? = null
        /**
         * The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. You can add up to 100 extra capacity units.
         */
        public var storageCapacityUnits: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration) : this() {
            this.queryCapacityUnits = x.queryCapacityUnits
            this.storageCapacityUnits = x.storageCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = CapacityUnitsConfiguration(this)

        internal fun correctErrors(): Builder {
            if (queryCapacityUnits == null) queryCapacityUnits = 0
            if (storageCapacityUnits == null) storageCapacityUnits = 0
            return this
        }
    }
}
