// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides a response when the status of a document could not be retrieved.
 */
public class BatchGetDocumentStatusResponseError private constructor(builder: Builder) {
    /**
     * The identifier of the data source connector that the failed document belongs to.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The identifier of the document whose status could not be retrieved.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * Indicates the source of the error.
     */
    public val errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = builder.errorCode
    /**
     * States that the API could not get the status of a document. This could be because the request is not valid or there is a system error.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetDocumentStatusResponseError(")
        append("dataSourceId=$dataSourceId,")
        append("documentId=$documentId,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId?.hashCode() ?: 0
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetDocumentStatusResponseError

        if (dataSourceId != other.dataSourceId) return false
        if (documentId != other.documentId) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the data source connector that the failed document belongs to.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The identifier of the document whose status could not be retrieved.
         */
        public var documentId: kotlin.String? = null
        /**
         * Indicates the source of the error.
         */
        public var errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = null
        /**
         * States that the API could not get the status of a document. This could be because the request is not valid or there is a system error.
         */
        public var errorMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError) : this() {
            this.dataSourceId = x.dataSourceId
            this.documentId = x.documentId
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = BatchGetDocumentStatusResponseError(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
